/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.Insets;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.util.Util;
import java.util.List;
import java.util.stream.Collectors;

public class ShadowTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    private static final char EMPTY_CHAR = ' ';
    private static final char UNICODE_SHADOW_CHAR = '\u2592';
    private static final char ASCII_SHADOW_CHAR = '#';
    private final char shadowChar;
    private final int verticalOffset;
    private final int horizontalOffset;

    public ShadowTreeNodeDecorator(TreeNode baseNode) {
        this(baseNode, new Builder());
    }

    private ShadowTreeNodeDecorator(TreeNode baseNode, Builder builder) {
        super(baseNode, builder.inherit, builder.decorable);
        this.shadowChar = builder.shadowChar;
        this.verticalOffset = builder.verticalOffset;
        this.horizontalOffset = builder.horizontalOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String decoratedContent() {
        int i;
        List lines = this.baseNode.content().lines().collect(Collectors.toList());
        int height = lines.size();
        int width = lines.stream().mapToInt(String::length).max().orElse(0);
        String shadowLine = this.buildShadowLine(width);
        String emptyPrefix = this.buildEmptyPrefix();
        String shadowPrefix = this.buildShadowPrefix();
        String shadowSuffix = this.buildShadowSuffix();
        StringBuilder resultBuilder = new StringBuilder();
        int topStart = Math.min(0, this.verticalOffset);
        int topEnd = Math.min(0, height + this.verticalOffset);
        int middleStart = Math.max(0, Math.min(height, this.verticalOffset));
        int middleEnd = Math.max(0, Math.min(height, height + this.verticalOffset));
        int bottomStart = Math.max(height, this.verticalOffset);
        int bottomEnd = Math.max(height, height + this.verticalOffset);
        for (i = topStart; i < topEnd; ++i) {
            resultBuilder.append(shadowLine);
            resultBuilder.append('\n');
        }
        for (i = topEnd; i < 0; ++i) {
            resultBuilder.append('\n');
        }
        for (i = 0; i < middleStart; ++i) {
            resultBuilder.append(emptyPrefix);
            resultBuilder.append((String)lines.get(i));
            resultBuilder.append('\n');
        }
        for (i = middleStart; i < middleEnd; ++i) {
            resultBuilder.append(shadowPrefix);
            resultBuilder.append((String)lines.get(i));
            resultBuilder.append(shadowSuffix);
            resultBuilder.append('\n');
        }
        for (i = middleEnd; i < height; ++i) {
            resultBuilder.append(emptyPrefix);
            resultBuilder.append((String)lines.get(i));
            resultBuilder.append('\n');
        }
        for (i = height; i < bottomStart; ++i) {
            resultBuilder.append('\n');
        }
        for (i = bottomStart; i < bottomEnd; ++i) {
            resultBuilder.append(shadowLine);
            resultBuilder.append('\n');
        }
        return resultBuilder.toString();
    }

    private String buildShadowLine(int width) {
        StringBuilder shadowLineBuilder = new StringBuilder();
        if (this.horizontalOffset > 0) {
            shadowLineBuilder.append(Util.repeat(' ', this.horizontalOffset));
        }
        shadowLineBuilder.append(Util.repeat(this.shadowChar, width));
        return shadowLineBuilder.toString();
    }

    private String buildEmptyPrefix() {
        if (this.horizontalOffset >= 0) {
            return "";
        }
        return Util.repeat(' ', -this.horizontalOffset);
    }

    private String buildShadowPrefix() {
        if (this.horizontalOffset >= 0) {
            return "";
        }
        return Util.repeat(this.shadowChar, -this.horizontalOffset);
    }

    private String buildShadowSuffix() {
        if (this.horizontalOffset <= 0) {
            return "";
        }
        return Util.repeat(this.shadowChar, this.horizontalOffset);
    }

    @Override
    public Insets insets() {
        Insets shadowInsets = new Insets(Math.max(0, -this.verticalOffset), Math.max(0, this.horizontalOffset), Math.max(0, this.verticalOffset), Math.max(0, -this.horizontalOffset));
        return this.baseNode.insets().extendedWith(shadowInsets);
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return ShadowTreeNodeDecorator.builder().decorable(this.decorable).inherit(this.inherit).shadowChar(this.shadowChar).verticalOffset(this.verticalOffset).horizontalOffset(this.horizontalOffset).buildFor(childNode);
    }

    public static class Builder {
        private boolean inherit = true;
        private boolean decorable = true;
        private char shadowChar = (char)(UnicodeMode.isUnicodeDefault() ? 9618 : 35);
        private int verticalOffset = 1;
        private int horizontalOffset = 1;

        public Builder inherit(boolean inherit) {
            this.inherit = inherit;
            return this;
        }

        public Builder decorable(boolean decorable) {
            this.decorable = decorable;
            return this;
        }

        public Builder shadowChar(char shadowChar) {
            this.shadowChar = shadowChar;
            return this;
        }

        public Builder verticalOffset(int verticalOffset) {
            this.verticalOffset = verticalOffset;
            return this;
        }

        public Builder horizontalOffset(int horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public ShadowTreeNodeDecorator buildFor(TreeNode node) {
            return new ShadowTreeNodeDecorator(node, this);
        }
    }
}

