/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.printer.listing;

import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.printer.TreePrinter;
import hu.webarticum.treeprinter.util.Util;
import java.util.ArrayList;

public class ListingTreePrinter
implements TreePrinter {
    private static final String[] DEFAULT_ASCII_LINE_STRINGS = new String[]{"   ", " | ", " |-", " '-", "---", "-+-"};
    private static final String[] DEFAULT_UNICODE_LINE_STRINGS = new String[]{"   ", " \u2502 ", " \u251c\u2500", " \u2514\u2500", "\u2500\u2500\u2500", "\u2500\u252c\u2500"};
    private final String liningSpace;
    private final String liningGeneral;
    private final String liningNode;
    private final String liningLastNode;
    private final String liningInset;
    private final String liningSub;
    private final boolean displayRoot;
    private final boolean displayPlaceholders;
    private final boolean align;
    private final boolean connectAlignedChildren;

    public ListingTreePrinter() {
        this(ListingTreePrinter.builder());
    }

    private ListingTreePrinter(Builder builder) {
        this.liningSpace = builder.lines[0];
        this.liningGeneral = builder.lines[1];
        this.liningNode = builder.lines[2];
        this.liningLastNode = builder.lines[3];
        this.liningInset = builder.lines[4];
        this.liningSub = builder.lines[5];
        this.displayRoot = builder.displayRoot;
        this.displayPlaceholders = builder.displayPlaceholders;
        this.align = builder.align;
        this.connectAlignedChildren = builder.connectAlignedChildren;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void print(TreeNode rootNode, Appendable out) {
        this.printSub(rootNode, out, "", NodeDisposition.ROOT, this.align ? Util.getDepth(rootNode) : 0);
    }

    private void printSub(TreeNode node, Appendable out, String prefix, NodeDisposition disposition, int inset) {
        String content = node.content();
        int connectOffset = node.insets().top();
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(node.children());
        if (!this.displayPlaceholders) {
            childNodes.removeIf(TreeNode::isPlaceholder);
        }
        String[] lines = Util.splitToLines(content);
        for (int i = 0; i < lines.length; ++i) {
            this.printContentLine(out, prefix, disposition, !childNodes.isEmpty(), inset, connectOffset, i, lines[i]);
        }
        int childNodeCount = childNodes.size();
        for (int i = 0; i < childNodeCount; ++i) {
            TreeNode childNode = (TreeNode)childNodes.get(i);
            boolean childIsLast = i == childNodeCount - 1;
            String lining = disposition == NodeDisposition.LAST ? this.liningSpace : this.liningGeneral;
            String subPrefix = disposition == NodeDisposition.ROOT ? prefix : prefix + lining;
            int subInset = Math.max(0, inset - 1);
            NodeDisposition subDisposition = childIsLast ? NodeDisposition.LAST : NodeDisposition.GENERAL;
            this.printSub(childNode, out, subPrefix, subDisposition, subInset);
        }
    }

    private void printContentLine(Appendable out, String prefix, NodeDisposition disposition, boolean hasChildren, int inset, int connectOffset, int i, String line) {
        if (disposition == NodeDisposition.ROOT) {
            if (this.displayRoot) {
                Util.writeln(out, prefix + line);
            }
            return;
        }
        String itemPrefix = this.buildItemPrefix(disposition, hasChildren, inset, connectOffset, i);
        Util.writeln(out, prefix + itemPrefix + line);
    }

    private String buildItemPrefix(NodeDisposition disposition, boolean hasChildren, int inset, int connectOffset, int i) {
        boolean isLast;
        StringBuilder resultBuilder = new StringBuilder();
        boolean bl = isLast = disposition == NodeDisposition.LAST;
        if (i < connectOffset) {
            resultBuilder.append(this.liningGeneral);
        } else if (i == connectOffset) {
            resultBuilder.append(isLast ? this.liningLastNode : this.liningNode);
        } else {
            resultBuilder.append(isLast ? this.liningSpace : this.liningGeneral);
        }
        String insetString = this.buildInsets(hasChildren, inset, connectOffset, i);
        resultBuilder.append(insetString);
        return resultBuilder.toString();
    }

    private String buildInsets(boolean hasChildren, int inset, int connectOffset, int i) {
        String insetString;
        if (inset == 0) {
            return "";
        }
        String firstInsetString = insetString = i == connectOffset ? this.liningInset : this.liningSpace;
        if (this.align && this.connectAlignedChildren && hasChildren) {
            if (i == connectOffset) {
                firstInsetString = this.liningSub;
            } else if (i > connectOffset) {
                firstInsetString = this.liningGeneral;
            }
        }
        StringBuilder insetBuilder = new StringBuilder();
        insetBuilder.append(firstInsetString);
        for (int j = 1; j < inset; ++j) {
            insetBuilder.append(insetString);
        }
        return insetBuilder.toString();
    }

    public static class Builder {
        private boolean displayRoot = true;
        private boolean displayPlaceholders = false;
        private boolean align = false;
        private boolean connectAlignedChildren = true;
        private String[] lines = UnicodeMode.isUnicodeDefault() ? (String[])ListingTreePrinter.access$500().clone() : (String[])ListingTreePrinter.access$600().clone();

        public Builder displayRoot(boolean displayRoot) {
            this.displayRoot = displayRoot;
            return this;
        }

        public Builder displayPlaceholders(boolean displayPlaceholders) {
            this.displayPlaceholders = displayPlaceholders;
            return this;
        }

        public Builder align(boolean align) {
            this.align = align;
            return this;
        }

        public Builder connectAlignedChildren(boolean connectAlignedChildren) {
            this.connectAlignedChildren = connectAlignedChildren;
            return this;
        }

        public Builder ascii() {
            this.lines = (String[])DEFAULT_ASCII_LINE_STRINGS.clone();
            return this;
        }

        public Builder unicode() {
            this.lines = (String[])DEFAULT_UNICODE_LINE_STRINGS.clone();
            return this;
        }

        public Builder lining(String space, String general, String node, String lastNode, String inset) {
            this.lines = new String[]{space, general, node, lastNode, inset};
            return this;
        }

        public Builder liningSpace(String liningSpace) {
            this.lines[0] = liningSpace;
            return this;
        }

        public Builder liningGeneral(String liningGeneral) {
            this.lines[1] = liningGeneral;
            return this;
        }

        public Builder liningNode(String liningNode) {
            this.lines[2] = liningNode;
            return this;
        }

        public Builder liningLastNode(String liningLastNode) {
            this.lines[3] = liningLastNode;
            return this;
        }

        public Builder liningInset(String liningInset) {
            this.lines[4] = liningInset;
            return this;
        }

        public ListingTreePrinter build() {
            return new ListingTreePrinter(this);
        }
    }

    private static enum NodeDisposition {
        ROOT,
        GENERAL,
        LAST;

    }
}

