/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.util;

import hu.webarticum.treeprinter.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LineBuffer {
    private final Appendable out;
    private int flushedRowCount = 0;
    private List<String> lines = new ArrayList<String>();

    public LineBuffer(Appendable out) {
        this.out = out;
    }

    public void write(int row, int col, String text) {
        String[] textLines = Util.splitToLines(text);
        int lineCount = textLines.length;
        for (int i = 0; i < lineCount; ++i) {
            this.writeLine(row + i, col, textLines[i]);
        }
    }

    public void flush() {
        this.flush(this.flushedRowCount + this.lines.size());
    }

    public void flush(int rows) {
        try {
            this.flushThrows(rows);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void flushThrows(int rows) throws IOException {
        int deleteLineCount;
        if (rows <= this.flushedRowCount) {
            return;
        }
        int currentLineCount = this.lines.size();
        if (currentLineCount <= (deleteLineCount = rows - this.flushedRowCount)) {
            for (String line : this.lines) {
                this.out.append(line + "\n");
            }
            this.lines.clear();
        } else {
            for (int i = 0; i < deleteLineCount; ++i) {
                String line = this.lines.get(i);
                this.out.append(line + "\n");
            }
            this.lines = new ArrayList<String>(this.lines.subList(deleteLineCount, currentLineCount));
        }
        this.flushedRowCount = rows;
    }

    private void writeLine(int row, int col, String textLine) {
        String originalLine;
        if (row < this.flushedRowCount) {
            return;
        }
        int lineIndex = row - this.flushedRowCount;
        int currentLineCount = this.lines.size();
        if (lineIndex < currentLineCount) {
            originalLine = this.lines.get(lineIndex);
        } else {
            for (int i = currentLineCount; i <= lineIndex; ++i) {
                this.lines.add("");
            }
            originalLine = "";
        }
        String newLine = this.writeIntoLine(originalLine, col, textLine);
        this.lines.set(lineIndex, newLine);
    }

    private String writeIntoLine(String contextLine, int pos, String textLine) {
        String beforePad;
        String beforeContent;
        int contextLineLength = contextLine.length();
        if (contextLineLength <= pos) {
            beforeContent = contextLine;
            beforePad = Util.repeat(' ', pos - contextLineLength);
        } else {
            beforeContent = contextLine.substring(0, pos);
            beforePad = "";
        }
        int textLineLength = textLine.length();
        String afterContent = pos + textLineLength < contextLineLength ? contextLine.substring(pos + textLineLength) : "";
        return beforeContent + beforePad + textLine + afterContent;
    }
}

