/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.util;

import hu.webarticum.treeprinter.TreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class Util {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\\R");

    private Util() {
    }

    public static int[] getContentDimension(String content) {
        String[] lines = Util.splitToLines(content);
        int longestLineLength = Util.getMaxLength(lines);
        return new int[]{longestLineLength, lines.length};
    }

    public static int getMaxLength(String[] lines) {
        int maxLength = 0;
        for (String line : lines) {
            int lineLength = line.length();
            if (lineLength <= maxLength) continue;
            maxLength = lineLength;
        }
        return maxLength;
    }

    public static String[] splitToLines(String content) {
        return LINE_SEPARATOR_PATTERN.split(content);
    }

    public static int getDepth(TreeNode treeNode) {
        ArrayList<TreeNode> levelNodes = new ArrayList<TreeNode>();
        levelNodes.add(treeNode);
        int depth = 0;
        while (true) {
            ArrayList<TreeNode> newLevelNodes = new ArrayList<TreeNode>();
            for (TreeNode levelNode : levelNodes) {
                for (TreeNode childNode : levelNode.children()) {
                    if (childNode == null) continue;
                    newLevelNodes.add(childNode);
                }
            }
            if (newLevelNodes.isEmpty()) break;
            levelNodes = newLevelNodes;
            ++depth;
        }
        return depth;
    }

    public static String repeat(char character, int repeats) {
        StringBuilder resultBuilder = new StringBuilder();
        Util.repeat(resultBuilder, character, repeats);
        return resultBuilder.toString();
    }

    public static void repeat(StringBuilder stringBuilder, char character, int repeats) {
        for (int i = 0; i < repeats; ++i) {
            stringBuilder.append(character);
        }
    }

    public static void write(Appendable out, String content) {
        try {
            out.append(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeln(Appendable out, String content) {
        Util.write(out, content + "\n");
    }
}

