/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter;

import hu.webarticum.treeprinter.Insets;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.text.ConsoleText;
import java.util.ArrayList;
import java.util.List;

public class SimpleTreeNode
implements TreeNode {
    private final ConsoleText content;
    private final Insets insets;
    private final List<TreeNode> children = new ArrayList<TreeNode>();

    public SimpleTreeNode(String content) {
        this(ConsoleText.of(content), Insets.EMPTY);
    }

    public SimpleTreeNode(String content, Insets insets) {
        this(ConsoleText.of(content), insets);
    }

    public SimpleTreeNode(ConsoleText content) {
        this(content, Insets.EMPTY);
    }

    public SimpleTreeNode(ConsoleText content, Insets insets) {
        this.content = content;
        this.insets = insets;
    }

    public void addChild(TreeNode childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException("Child node must not be null, use placeholder instead");
        }
        this.children.add(childNode);
    }

    @Override
    public ConsoleText content() {
        return this.content;
    }

    @Override
    public Insets insets() {
        return this.insets;
    }

    @Override
    public List<TreeNode> children() {
        return new ArrayList<TreeNode>(this.children);
    }
}

