/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.Insets;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.text.ConsoleText;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTreeNodeDecorator
implements TreeNode {
    protected final TreeNode baseNode;
    protected final boolean inherit;
    protected final boolean decorable;

    protected AbstractTreeNodeDecorator(TreeNode baseNode) {
        this(baseNode, true);
    }

    protected AbstractTreeNodeDecorator(TreeNode baseNode, boolean inherit) {
        this(baseNode, inherit, baseNode.isDecorable());
    }

    protected AbstractTreeNodeDecorator(TreeNode baseNode, boolean inherit, boolean decorable) {
        if (baseNode == null) {
            throw new IllegalArgumentException("Decorated node must not be null");
        }
        this.baseNode = baseNode;
        this.inherit = inherit;
        this.decorable = decorable;
    }

    @Override
    public ConsoleText content() {
        if (this.baseNode.isDecorable()) {
            return this.decoratedContent();
        }
        return this.baseNode.content();
    }

    public TreeNode getDecoratedNode() {
        return this.baseNode;
    }

    @Override
    public TreeNode originalNode() {
        return this.baseNode.originalNode();
    }

    @Override
    public Insets insets() {
        return this.baseNode.insets();
    }

    @Override
    public boolean isDecorable() {
        return this.decorable;
    }

    @Override
    public boolean isPlaceholder() {
        return this.baseNode.isPlaceholder();
    }

    @Override
    public List<TreeNode> children() {
        ArrayList<TreeNode> wrappedChildren = new ArrayList<TreeNode>();
        List<TreeNode> originalChildren = this.baseNode.children();
        int childCount = originalChildren.size();
        for (int i = 0; i < childCount; ++i) {
            TreeNode childNode = originalChildren.get(i);
            TreeNode wrappedChildNode = this.inherit ? this.wrapChild(childNode, i) : childNode;
            wrappedChildren.add(wrappedChildNode);
        }
        return wrappedChildren;
    }

    protected abstract ConsoleText decoratedContent();

    protected abstract TreeNode wrapChild(TreeNode var1, int var2);
}

