/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.Insets;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.text.AnsiFormat;
import hu.webarticum.treeprinter.text.ConsoleText;
import hu.webarticum.treeprinter.text.Dimensions;
import hu.webarticum.treeprinter.text.PlainConsoleText;
import hu.webarticum.treeprinter.text.TextUtil;

public class ShadowTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    private static final char EMPTY_CHAR = ' ';
    private static final char UNICODE_SHADOW_CHAR = '\u2592';
    private static final char ASCII_SHADOW_CHAR = '#';
    private final char shadowChar;
    private final int verticalOffset;
    private final int horizontalOffset;
    private final AnsiFormat format;

    public ShadowTreeNodeDecorator(TreeNode baseNode) {
        this(baseNode, ShadowTreeNodeDecorator.builder());
    }

    public ShadowTreeNodeDecorator(TreeNode baseNode, AnsiFormat format) {
        this(baseNode, ShadowTreeNodeDecorator.builder().format(format));
    }

    private ShadowTreeNodeDecorator(TreeNode baseNode, Builder builder) {
        super(baseNode, builder.inherit, builder.decorable);
        this.shadowChar = builder.shadowChar;
        this.verticalOffset = builder.verticalOffset;
        this.horizontalOffset = builder.horizontalOffset;
        this.format = builder.format;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ConsoleText decoratedContent() {
        int i;
        ConsoleText baseContent = this.baseNode.content();
        ConsoleText[] baseLines = TextUtil.linesOf(baseContent);
        Dimensions baseDimensions = baseContent.dimensions();
        int baseWidth = baseDimensions.width();
        int baseHeight = baseDimensions.height();
        String shadowLine = this.buildShadowLine(baseWidth);
        String shadowEmptyPrefix = this.buildShadowEmptyPrefix();
        String emptyPrefix = this.buildEmptyPrefix();
        String shadowPrefix = this.buildShadowPrefix();
        String shadowSuffix = this.buildShadowSuffix();
        StringBuilder resultBuilder = new StringBuilder();
        int topStart = Math.min(0, this.verticalOffset);
        int topEnd = Math.min(0, baseHeight + this.verticalOffset);
        int middleStart = Math.max(0, Math.min(baseHeight, this.verticalOffset));
        int middleEnd = Math.max(0, Math.min(baseHeight, baseHeight + this.verticalOffset));
        int bottomStart = Math.max(baseHeight, this.verticalOffset);
        int bottomEnd = Math.max(baseHeight, baseHeight + this.verticalOffset);
        for (i = topStart; i < topEnd; ++i) {
            resultBuilder.append(shadowEmptyPrefix);
            resultBuilder.append(shadowLine);
            resultBuilder.append('\n');
        }
        for (i = topEnd; i < 0; ++i) {
            resultBuilder.append('\n');
        }
        for (i = 0; i < middleStart; ++i) {
            resultBuilder.append(emptyPrefix);
            resultBuilder.append(baseLines[i].ansi());
            resultBuilder.append('\n');
        }
        for (i = middleStart; i < middleEnd; ++i) {
            resultBuilder.append(this.formatShadow(shadowPrefix).ansi());
            resultBuilder.append(baseLines[i].ansi());
            TextUtil.repeat(resultBuilder, ' ', baseWidth - baseLines[i].dimensions().width());
            resultBuilder.append(this.formatShadow(shadowSuffix).ansi());
            resultBuilder.append('\n');
        }
        for (i = middleEnd; i < baseHeight; ++i) {
            resultBuilder.append(emptyPrefix);
            resultBuilder.append(baseLines[i].ansi());
            resultBuilder.append('\n');
        }
        for (i = baseHeight; i < bottomStart; ++i) {
            resultBuilder.append('\n');
        }
        for (i = bottomStart; i < bottomEnd; ++i) {
            resultBuilder.append(shadowEmptyPrefix);
            resultBuilder.append(this.formatShadow(shadowLine).ansi());
            resultBuilder.append('\n');
        }
        String decoratedContent = resultBuilder.toString();
        boolean isPlain = this.baseNode instanceof PlainConsoleText && this.format == AnsiFormat.NONE;
        return isPlain ? ConsoleText.of(decoratedContent) : ConsoleText.ofAnsi(decoratedContent);
    }

    private ConsoleText formatShadow(String shadowText) {
        return ConsoleText.of(shadowText).format(this.format);
    }

    private String buildShadowLine(int width) {
        return TextUtil.repeat(this.shadowChar, width);
    }

    private String buildShadowEmptyPrefix() {
        if (this.horizontalOffset <= 0) {
            return "";
        }
        return TextUtil.repeat(' ', this.horizontalOffset);
    }

    private String buildEmptyPrefix() {
        if (this.horizontalOffset >= 0) {
            return "";
        }
        return TextUtil.repeat(' ', -this.horizontalOffset);
    }

    private String buildShadowPrefix() {
        if (this.horizontalOffset >= 0) {
            return "";
        }
        return TextUtil.repeat(this.shadowChar, -this.horizontalOffset);
    }

    private String buildShadowSuffix() {
        if (this.horizontalOffset <= 0) {
            return "";
        }
        return TextUtil.repeat(this.shadowChar, this.horizontalOffset);
    }

    @Override
    public Insets insets() {
        Insets shadowInsets = new Insets(Math.max(0, -this.verticalOffset), Math.max(0, this.horizontalOffset), Math.max(0, this.verticalOffset), Math.max(0, -this.horizontalOffset));
        return this.baseNode.insets().extendedWith(shadowInsets);
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return ShadowTreeNodeDecorator.builder().decorable(this.decorable).inherit(this.inherit).shadowChar(this.shadowChar).verticalOffset(this.verticalOffset).horizontalOffset(this.horizontalOffset).format(this.format).buildFor(childNode);
    }

    public static class Builder {
        private boolean inherit = true;
        private boolean decorable = true;
        private char shadowChar = (char)(UnicodeMode.isUnicodeDefault() ? 9618 : 35);
        private int verticalOffset = 1;
        private int horizontalOffset = 1;
        private AnsiFormat format = AnsiFormat.NONE;

        public Builder inherit(boolean inherit) {
            this.inherit = inherit;
            return this;
        }

        public Builder decorable(boolean decorable) {
            this.decorable = decorable;
            return this;
        }

        public Builder shadowChar(char shadowChar) {
            this.shadowChar = shadowChar;
            return this;
        }

        public Builder verticalOffset(int verticalOffset) {
            this.verticalOffset = verticalOffset;
            return this;
        }

        public Builder horizontalOffset(int horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public Builder format(AnsiFormat format) {
            this.format = format;
            return this;
        }

        public ShadowTreeNodeDecorator buildFor(TreeNode node) {
            return new ShadowTreeNodeDecorator(node, this);
        }
    }
}

