/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.text.ConsoleText;

public class TrackingTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    public final TrackingTreeNodeDecorator parent;
    public final int index;

    public TrackingTreeNodeDecorator(TreeNode baseNode) {
        this(baseNode, null, 0);
    }

    public TrackingTreeNodeDecorator(TreeNode baseNode, TrackingTreeNodeDecorator parent, int index) {
        super(baseNode);
        this.parent = parent;
        this.index = index;
    }

    @Override
    public ConsoleText decoratedContent() {
        return this.baseNode.content();
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return new TrackingTreeNodeDecorator(childNode, this, index);
    }

    @Override
    public boolean isDecorable() {
        return false;
    }

    public int hashCode() {
        int parentHashCode = this.parent != null ? this.parent.hashCode() : 0;
        return parentHashCode * 37 + this.index;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TrackingTreeNodeDecorator)) {
            return false;
        }
        TrackingTreeNodeDecorator otherTrackingTreeNodeDecorator = (TrackingTreeNodeDecorator)other;
        TrackingTreeNodeDecorator otherParent = otherTrackingTreeNodeDecorator.parent;
        if (this == otherTrackingTreeNodeDecorator) {
            return true;
        }
        if (this.parent == null ? otherParent != null : otherParent == null || !this.parent.equals(otherParent)) {
            return false;
        }
        return this.index == otherTrackingTreeNodeDecorator.index;
    }
}

