/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.printer.traditional;

import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.printer.traditional.Liner;
import hu.webarticum.treeprinter.text.AnsiFormat;
import hu.webarticum.treeprinter.text.ConsoleText;
import hu.webarticum.treeprinter.text.LineBuffer;
import java.util.List;

public class DefaultLiner
implements Liner {
    private static final char[] LINE_CHARS_ASCII = new char[]{'|', ' ', '_', '|', '|', '|', '_', '|', '|', '|', ' ', '|', '|'};
    private static final char[] LINE_CHARS_UNICODE = new char[]{'\u2502', '\u250c', '\u2500', '\u2534', '\u2514', '\u2518', '\u252c', '\u253c', '\u251c', '\u2524', '\u2510', '\u2502', '\u2502'};
    private final char topConnectionChar;
    private final char bracketLeftChar;
    private final char bracketChar;
    private final char bracketTopChar;
    private final char bracketTopLeftChar;
    private final char bracketTopRightChar;
    private final char bracketBottomChar;
    private final char bracketTopAndBottomChar;
    private final char bracketTopAndBottomLeftChar;
    private final char bracketTopAndBottomRightChar;
    private final char bracketRightChar;
    private final char bracketOnlyChar;
    private final char bottomConnectionChar;
    private final int topHeight;
    private final int bottomHeight;
    private final boolean displayBracket;
    private final AnsiFormat format;

    public DefaultLiner() {
        this(DefaultLiner.builder());
    }

    public DefaultLiner(AnsiFormat format) {
        this(DefaultLiner.builder().format(format));
    }

    public DefaultLiner(boolean useUnicode) {
        this(DefaultLiner.builder().unicode(useUnicode));
    }

    public DefaultLiner(boolean useUnicode, AnsiFormat format) {
        this(DefaultLiner.builder().unicode(useUnicode).format(format));
    }

    private DefaultLiner(Builder builder) {
        this.topConnectionChar = builder.characters[0];
        this.bracketLeftChar = builder.characters[1];
        this.bracketChar = builder.characters[2];
        this.bracketTopChar = builder.characters[3];
        this.bracketTopLeftChar = builder.characters[4];
        this.bracketTopRightChar = builder.characters[5];
        this.bracketBottomChar = builder.characters[6];
        this.bracketTopAndBottomChar = builder.characters[7];
        this.bracketTopAndBottomLeftChar = builder.characters[8];
        this.bracketTopAndBottomRightChar = builder.characters[9];
        this.bracketRightChar = builder.characters[10];
        this.bracketOnlyChar = builder.characters[11];
        this.bottomConnectionChar = builder.characters[12];
        this.topHeight = builder.topHeight;
        this.bottomHeight = builder.bottomHeight;
        this.displayBracket = builder.displayBracket;
        this.format = builder.format;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int printConnections(LineBuffer buffer, int row, int topConnection, List<Integer> bottomConnections) {
        int start = Math.min(topConnection, bottomConnections.get(0));
        int end = Math.max(topConnection, bottomConnections.get(bottomConnections.size() - 1));
        int topHeightWithBracket = this.topHeight + (this.displayBracket ? 1 : 0);
        int fullHeight = topHeightWithBracket + this.bottomHeight;
        this.printTopConnection(buffer, row, topConnection);
        this.printConnectionBracketLine(buffer, row, start, end, topConnection, bottomConnections);
        this.printBottomConnections(buffer, row, start, topHeightWithBracket, fullHeight, bottomConnections);
        return fullHeight;
    }

    private void printTopConnection(LineBuffer buffer, int row, int topConnection) {
        for (int i = 0; i < this.topHeight; ++i) {
            buffer.write(row + i, topConnection, this.formatLining(this.topConnectionChar));
        }
    }

    private void printConnectionBracketLine(LineBuffer buffer, int row, int start, int end, int topConnection, List<Integer> bottomConnections) {
        StringBuilder bracketLineBuilder = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            char lineCharacter = this.getNthBracketLineChar(i, start, end, topConnection, bottomConnections);
            bracketLineBuilder.append(lineCharacter);
        }
        buffer.write(row + this.topHeight, start, this.formatLining(bracketLineBuilder.toString()));
    }

    private char getNthBracketLineChar(int i, int start, int end, int topConnection, List<Integer> bottomConnections) {
        if (start == end) {
            return this.bracketOnlyChar;
        }
        if (i == topConnection) {
            return this.getBracketLineCharAtTopConnection(topConnection, start, end, bottomConnections);
        }
        if (i == start) {
            return this.bracketLeftChar;
        }
        if (i == end) {
            return this.bracketRightChar;
        }
        if (bottomConnections.contains(i)) {
            return this.bracketBottomChar;
        }
        return this.bracketChar;
    }

    private char getBracketLineCharAtTopConnection(int i, int start, int end, List<Integer> bottomConnections) {
        if (bottomConnections.contains(i)) {
            if (i == start) {
                return this.bracketTopAndBottomLeftChar;
            }
            if (i == end) {
                return this.bracketTopAndBottomRightChar;
            }
            return this.bracketTopAndBottomChar;
        }
        if (i == start) {
            return this.bracketTopLeftChar;
        }
        if (i == end) {
            return this.bracketTopRightChar;
        }
        return this.bracketTopChar;
    }

    private void printBottomConnections(LineBuffer buffer, int row, int start, int topHeightWithBracket, int fullHeight, List<Integer> bottomConnections) {
        StringBuilder bottomConnectionLineBuilder = new StringBuilder();
        int position = start;
        for (int bottomConnection : bottomConnections) {
            for (int i = position; i < bottomConnection; ++i) {
                bottomConnectionLineBuilder.append(' ');
            }
            bottomConnectionLineBuilder.append(this.bottomConnectionChar);
            position = bottomConnection + 1;
        }
        ConsoleText bottomConnectionLineContent = this.formatLining(bottomConnectionLineBuilder.toString());
        for (int i = topHeightWithBracket; i < fullHeight; ++i) {
            buffer.write(row + i, start, bottomConnectionLineContent);
        }
    }

    private ConsoleText formatLining(char liningChar) {
        return this.formatLining("" + liningChar);
    }

    private ConsoleText formatLining(String liningText) {
        return ConsoleText.of(liningText).format(this.format);
    }

    public static class Builder {
        private int topHeight = 0;
        private int bottomHeight = 1;
        private boolean displayBracket = true;
        private char[] characters = UnicodeMode.isUnicodeDefault() ? (char[])DefaultLiner.access$500().clone() : (char[])DefaultLiner.access$600().clone();
        private AnsiFormat format = AnsiFormat.NONE;

        public Builder topHeight(int topHeight) {
            this.topHeight = topHeight;
            return this;
        }

        public Builder bottomHeight(int bottomHeight) {
            this.bottomHeight = bottomHeight;
            return this;
        }

        public Builder displayBracket(boolean displayBracket) {
            this.displayBracket = displayBracket;
            return this;
        }

        public Builder ascii() {
            return this.unicode(false);
        }

        public Builder unicode() {
            return this.unicode(true);
        }

        public Builder unicode(boolean useUnicode) {
            this.characters = useUnicode ? LINE_CHARS_UNICODE : LINE_CHARS_ASCII;
            return this;
        }

        public Builder topConnectionChar(char topConnectionChar) {
            this.characters[0] = topConnectionChar;
            return this;
        }

        public Builder bracketLeftChar(char bracketLeftChar) {
            this.characters[1] = bracketLeftChar;
            return this;
        }

        public Builder bracketChar(char bracketChar) {
            this.characters[2] = bracketChar;
            return this;
        }

        public Builder bracketTopChar(char bracketTopChar) {
            this.characters[3] = bracketTopChar;
            return this;
        }

        public Builder bracketTopLeftChar(char bracketTopLeftChar) {
            this.characters[4] = bracketTopLeftChar;
            return this;
        }

        public Builder bracketTopRightChar(char bracketTopRightChar) {
            this.characters[5] = bracketTopRightChar;
            return this;
        }

        public Builder bracketBottomChar(char bracketBottomChar) {
            this.characters[6] = bracketBottomChar;
            return this;
        }

        public Builder bracketTopAndBottomChar(char bracketTopAndBottomChar) {
            this.characters[7] = bracketTopAndBottomChar;
            return this;
        }

        public Builder bracketTopAndBottomLeftChar(char bracketTopAndBottomLeftChar) {
            this.characters[8] = bracketTopAndBottomLeftChar;
            return this;
        }

        public Builder bracketTopAndBottomRightChar(char bracketTopAndBottomRightChar) {
            this.characters[9] = bracketTopAndBottomRightChar;
            return this;
        }

        public Builder bracketRightChar(char bracketRightChar) {
            this.characters[10] = bracketRightChar;
            return this;
        }

        public Builder bracketOnlyChar(char bracketOnlyChar) {
            this.characters[11] = bracketOnlyChar;
            return this;
        }

        public Builder bottomConnectionChar(char bottomConnectionChar) {
            this.characters[12] = bottomConnectionChar;
            return this;
        }

        public Builder format(AnsiFormat format) {
            this.format = format;
            return this;
        }

        public DefaultLiner build() {
            return new DefaultLiner(this);
        }
    }
}

