/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.text;

import hu.webarticum.treeprinter.text.LineMerger;
import hu.webarticum.treeprinter.text.TextUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnsiLineMerger
implements LineMerger {
    private static final char ESCAPE_CHAR = '\u001b';
    private static final Pattern ANSI_ESCAPE_START_PATTERN = Pattern.compile("^\\e(?:\\[[0-9;]*m)?");

    @Override
    public String merge(String existingLine, int fromPosition, String replacement) {
        StringBuilder innerEscapeStack;
        int innerRight;
        StringBuilder resultBuilder = new StringBuilder();
        int replacementLength = replacement.length();
        StringBuilder replacementEscapeStack = new StringBuilder();
        int replacementAfterLocation = replacementLength + 1;
        int replacementDiff = this.locate(replacement, 0, 0, replacementAfterLocation, replacementEscapeStack);
        int replacementWidth = replacementAfterLocation + replacementDiff;
        int replacementVisibleEnd = fromPosition + replacementWidth;
        StringBuilder leadingEscapeStack = new StringBuilder();
        int leadingLength = -fromPosition;
        if (fromPosition > 0 && !existingLine.isEmpty()) {
            leadingLength = this.locate(existingLine, 0, 0, fromPosition, leadingEscapeStack);
            String leading = leadingLength > 0 ? existingLine.substring(0, leadingLength) : existingLine;
            resultBuilder.append(leading);
            if (!leadingEscapeStack.isEmpty()) {
                resultBuilder.append(TextUtil.ansiReset());
            }
        }
        if (leadingLength < 0) {
            TextUtil.repeat(resultBuilder, ' ', -leadingLength);
        }
        resultBuilder.append(replacement);
        if (!replacementEscapeStack.isEmpty()) {
            resultBuilder.append(TextUtil.ansiReset());
        }
        if (leadingLength >= 0 && !existingLine.isEmpty() && (innerRight = this.locate(existingLine, leadingLength, fromPosition, replacementVisibleEnd, innerEscapeStack = new StringBuilder())) >= 0) {
            resultBuilder.append((CharSequence)leadingEscapeStack);
            resultBuilder.append((CharSequence)innerEscapeStack);
            resultBuilder.append(existingLine.substring(innerRight));
        }
        return resultBuilder.toString();
    }

    private int locate(String line, int startLocation, int startVisibleLocation, int targetVisibleLocation, StringBuilder escapeStack) {
        int length = line.length();
        int location = startLocation;
        int visibleLocation = startVisibleLocation;
        while (location < length && visibleLocation < targetVisibleLocation) {
            char c = line.charAt(location);
            if (c == '\u001b') {
                String ansiEscape = this.getAnsiEscape(line, location);
                if (ansiEscape.equals(TextUtil.ansiReset())) {
                    escapeStack.setLength(0);
                } else {
                    escapeStack.append(ansiEscape);
                }
                location += ansiEscape.length();
                continue;
            }
            ++location;
            ++visibleLocation;
        }
        if (location < length && line.substring(location).equals(TextUtil.ansiReset())) {
            escapeStack.setLength(0);
            return length;
        }
        if (visibleLocation < targetVisibleLocation) {
            return visibleLocation - targetVisibleLocation;
        }
        return location;
    }

    private String getAnsiEscape(String line, int position) {
        Matcher matcher = ANSI_ESCAPE_START_PATTERN.matcher(line.substring(position));
        if (!matcher.find()) {
            return "\u001b";
        }
        return matcher.group();
    }
}

