/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.text;

import hu.webarticum.treeprinter.text.AnsiConsoleText;
import hu.webarticum.treeprinter.text.AnsiFormat;
import hu.webarticum.treeprinter.text.Dimensions;
import hu.webarticum.treeprinter.text.PlainConsoleText;
import hu.webarticum.treeprinter.text.TextUtil;
import java.util.Arrays;

public interface ConsoleText {
    public String plain();

    public String ansi();

    public ConsoleText concat(ConsoleText var1);

    default public int length() {
        return this.plain().length();
    }

    default public Dimensions dimensions() {
        String plainContent = this.plain();
        String[] lines = TextUtil.linesOf(plainContent);
        int width = 0;
        int height = 0;
        for (int i = 0; i < lines.length; ++i) {
            int length = lines[i].length();
            if (length > width) {
                width = length;
            }
            ++height;
        }
        return new Dimensions(width, height);
    }

    public static ConsoleText empty() {
        return new PlainConsoleText("");
    }

    public static ConsoleText of(char plainChar) {
        return new PlainConsoleText(plainChar);
    }

    public static ConsoleText of(String plainText) {
        return new PlainConsoleText(plainText);
    }

    public static ConsoleText ofAnsi(String ansiText) {
        return new AnsiConsoleText(ansiText);
    }

    default public ConsoleText format(AnsiFormat format) {
        if (format.toString().isEmpty()) {
            return this;
        }
        String formattedString = Arrays.stream(TextUtil.linesOf(this.ansi())).map(s -> TextUtil.formatLine(s, format)).reduce((s1, s2) -> s1 + '\n' + s2).orElse("");
        return ConsoleText.ofAnsi(formattedString);
    }
}

