/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.HorizontalAlign;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.VerticalAlign;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.text.AnsiFormat;
import hu.webarticum.treeprinter.text.ConsoleText;
import hu.webarticum.treeprinter.text.Dimensions;
import hu.webarticum.treeprinter.text.PlainConsoleText;
import hu.webarticum.treeprinter.text.TextUtil;

public class JustifyTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    private final int minimumWidth;
    private final int minimumHeight;
    private final HorizontalAlign horizontalAlign;
    private final VerticalAlign verticalAlign;
    private final char background;
    private final AnsiFormat backgroundFormat;

    public JustifyTreeNodeDecorator(TreeNode decoratedNode) {
        this(decoratedNode, JustifyTreeNodeDecorator.builder());
    }

    public JustifyTreeNodeDecorator(TreeNode decoratedNode, AnsiFormat backgroundFormat) {
        this(decoratedNode, JustifyTreeNodeDecorator.builder().backgroundFormat(backgroundFormat));
    }

    public JustifyTreeNodeDecorator(TreeNode decoratedNode, HorizontalAlign textAlign, AnsiFormat backgroundFormat) {
        this(decoratedNode, JustifyTreeNodeDecorator.builder().horizontalAlign(textAlign).backgroundFormat(backgroundFormat));
    }

    private JustifyTreeNodeDecorator(TreeNode decoratedNode, Builder builder) {
        super(decoratedNode, builder.inherit, builder.decorable);
        this.minimumWidth = builder.minimumWidth;
        this.minimumHeight = builder.minimumHeight;
        this.horizontalAlign = builder.horizontalAlign;
        this.verticalAlign = builder.verticalAlign;
        this.background = builder.background;
        this.backgroundFormat = builder.backgroundFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected ConsoleText decoratedContent() {
        ConsoleText baseContent = this.baseNode.content();
        ConsoleText[] baseLines = TextUtil.linesOf(baseContent);
        Dimensions baseDimensions = baseContent.dimensions();
        int fullWidth = Math.max(this.minimumWidth, baseDimensions.width());
        int fullHeight = Math.max(this.minimumHeight, baseDimensions.height());
        int topPad = this.getStartPad(fullHeight, baseDimensions.height(), (Object)this.verticalAlign);
        int bottomPad = fullHeight - baseDimensions.height() - topPad;
        StringBuilder resultBuilder = new StringBuilder();
        this.appendTopLines(resultBuilder, fullWidth, topPad);
        this.appendMiddleLines(resultBuilder, baseLines, fullWidth);
        this.appendBottomLines(resultBuilder, fullWidth, bottomPad);
        String decoratedContent = resultBuilder.toString();
        boolean isPlain = this.baseNode instanceof PlainConsoleText && this.backgroundFormat == AnsiFormat.NONE;
        return isPlain ? ConsoleText.of(decoratedContent) : ConsoleText.ofAnsi(decoratedContent);
    }

    private void appendTopLines(StringBuilder contentBuilder, int width, int height) {
        for (int i = 0; i < height; ++i) {
            contentBuilder.append(this.composeBackground(width).ansi());
            contentBuilder.append('\n');
        }
    }

    private void appendMiddleLines(StringBuilder contentBuilder, ConsoleText[] baseLines, int fullWidth) {
        boolean first = true;
        for (ConsoleText baseLine : baseLines) {
            if (first) {
                first = false;
            } else {
                contentBuilder.append('\n');
            }
            this.appendMiddleLine(contentBuilder, baseLine, fullWidth);
        }
    }

    private void appendMiddleLine(StringBuilder contentBuilder, ConsoleText baseLine, int fullWidth) {
        int baseLineWidth = baseLine.dimensions().width();
        int leftPad = this.getStartPad(fullWidth, baseLineWidth, (Object)this.horizontalAlign);
        int rightPad = fullWidth - baseLineWidth - leftPad;
        contentBuilder.append(this.composeBackground(leftPad).ansi());
        contentBuilder.append(baseLine.ansi());
        contentBuilder.append(this.composeBackground(rightPad).ansi());
    }

    private void appendBottomLines(StringBuilder contentBuilder, int width, int height) {
        for (int i = 0; i < height; ++i) {
            contentBuilder.append('\n');
            contentBuilder.append(this.composeBackground(width).ansi());
        }
    }

    private int getStartPad(int fullSize, int contentSize, Object alignType) {
        if (alignType == HorizontalAlign.LEFT || alignType == VerticalAlign.TOP) {
            return 0;
        }
        int remainingSize = fullSize - contentSize;
        if (alignType == HorizontalAlign.RIGHT || alignType == VerticalAlign.BOTTOM) {
            return remainingSize;
        }
        return remainingSize / 2;
    }

    private ConsoleText composeBackground(int width) {
        return ConsoleText.of(TextUtil.repeat(this.background, width)).format(this.backgroundFormat);
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return new JustifyTreeNodeDecorator(childNode, JustifyTreeNodeDecorator.builder().decorable(this.decorable).inherit(this.inherit).minimumWidth(this.minimumWidth).minimumHeight(this.minimumHeight).horizontalAlign(this.horizontalAlign).verticalAlign(this.verticalAlign).background(this.background).backgroundFormat(this.backgroundFormat));
    }

    public static class Builder {
        private boolean inherit = true;
        private boolean decorable = true;
        private int minimumWidth = 0;
        private int minimumHeight = 0;
        private HorizontalAlign horizontalAlign = HorizontalAlign.LEFT;
        private VerticalAlign verticalAlign = VerticalAlign.TOP;
        private char background = (char)32;
        private AnsiFormat backgroundFormat = AnsiFormat.NONE;

        public Builder inherit(boolean inherit) {
            this.inherit = inherit;
            return this;
        }

        public Builder decorable(boolean decorable) {
            this.decorable = decorable;
            return this;
        }

        public Builder minimumWidth(int minimumWidth) {
            this.minimumWidth = minimumWidth;
            return this;
        }

        public Builder minimumHeight(int minimumHeight) {
            this.minimumHeight = minimumHeight;
            return this;
        }

        public Builder horizontalAlign(HorizontalAlign horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
            return this;
        }

        public Builder verticalAlign(VerticalAlign verticalAlign) {
            this.verticalAlign = verticalAlign;
            return this;
        }

        public Builder background(char background) {
            this.background = background;
            return this;
        }

        public Builder backgroundFormat(AnsiFormat backgroundFormat) {
            this.backgroundFormat = backgroundFormat;
            return this;
        }

        public JustifyTreeNodeDecorator buildFor(TreeNode node) {
            return new JustifyTreeNodeDecorator(node, this);
        }
    }
}

