/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.misc.fs;

import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.misc.fs.FsTreeNode;
import hu.webarticum.treeprinter.text.ConsoleText;
import java.io.File;
import java.text.DecimalFormat;

public class DefaultFsTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    public DefaultFsTreeNodeDecorator(TreeNode baseNode) {
        super(baseNode);
    }

    public DefaultFsTreeNodeDecorator(TreeNode baseNode, boolean inherit) {
        super(baseNode, inherit);
    }

    public DefaultFsTreeNodeDecorator(TreeNode baseNode, boolean inherit, boolean decorable) {
        super(baseNode, inherit, decorable);
    }

    @Override
    public ConsoleText decoratedContent() {
        if (this.baseNode instanceof FsTreeNode) {
            FsTreeNode fsNode = (FsTreeNode)this.baseNode;
            File file = fsNode.getFile();
            if (file.isDirectory()) {
                return ConsoleText.of(" " + file.getName() + "/");
            }
            return ConsoleText.of(" " + file.getName() + " (" + this.formatFileSize(file.length()) + ")");
        }
        return this.baseNode.content();
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return new DefaultFsTreeNodeDecorator(childNode, this.decorable, this.inherit);
    }

    protected String formatFileSize(long fileSize) {
        String[] suffixes = new String[]{" KB", " MB", " GB", " TB"};
        double floatingSize = fileSize;
        String suffix = " b";
        for (String _suffix : suffixes) {
            if (!(floatingSize > 850.0)) continue;
            floatingSize /= 1024.0;
            suffix = _suffix;
        }
        return new DecimalFormat("#.##").format(floatingSize) + suffix;
    }
}

