/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.printer.traditional;

import hu.webarticum.treeprinter.HorizontalAlign;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.printer.traditional.Aligner;
import hu.webarticum.treeprinter.printer.traditional.Placement;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultAligner
implements Aligner {
    private final HorizontalAlign contentAlign;
    private final int contentOffset;
    private final ConnectMode topConnectionConnect;
    private final HorizontalAlign topConnectionAlign;
    private final int topConnectionOffset;
    private final ConnectMode bottomConnectionConnect;
    private final HorizontalAlign bottomConnectionAlign;
    private final int bottomConnectionOffset;
    private final HorizontalAlign childrenAlign;
    private final int gap;

    public DefaultAligner() {
        this(HorizontalAlign.CENTER);
    }

    public DefaultAligner(HorizontalAlign align) {
        this(align, 1);
    }

    public DefaultAligner(HorizontalAlign align, int gap) {
        this(DefaultAligner.builder().align(align).gap(gap));
    }

    private DefaultAligner(Builder builder) {
        this.contentAlign = builder.contentAlign;
        this.contentOffset = builder.contentOffset;
        this.topConnectionConnect = builder.topConnectionConnect;
        this.topConnectionAlign = builder.topConnectionAlign;
        this.topConnectionOffset = builder.topConnectionOffset;
        this.bottomConnectionConnect = builder.bottomConnectionConnect;
        this.bottomConnectionAlign = builder.bottomConnectionAlign;
        this.bottomConnectionOffset = builder.bottomConnectionOffset;
        this.childrenAlign = builder.childrenAlign;
        this.gap = builder.gap;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Placement alignNode(TreeNode node, int position, int width, int contentWidth) {
        int contentMaxLeft = position + width - contentWidth;
        int connectionMaxLeft = position + width - 1;
        int left = this.calculateLeft(position, width, contentWidth, contentMaxLeft);
        int topConnection = this.calculateTopConnection(left, position, width, contentWidth, connectionMaxLeft);
        int bottomConnection = this.calculateBottomConnection(left, position, width, contentWidth, connectionMaxLeft);
        return new Placement(left, topConnection, bottomConnection);
    }

    private int calculateLeft(int position, int width, int contentWidth, int contentMaxLeft) {
        int relativeLeft = this.contentAlign == HorizontalAlign.LEFT ? position : (this.contentAlign == HorizontalAlign.RIGHT ? contentMaxLeft : position + (width - contentWidth) / 2);
        return this.restrictInt(relativeLeft + this.contentOffset, 0, contentMaxLeft);
    }

    private int calculateTopConnection(int left, int position, int width, int contentWidth, int connectionMaxLeft) {
        int relativeTopConnection = this.topConnectionConnect == ConnectMode.CONTENT ? (this.topConnectionAlign == HorizontalAlign.LEFT ? left : (this.topConnectionAlign == HorizontalAlign.RIGHT ? left + contentWidth - 1 : left + contentWidth / 2)) : (this.topConnectionAlign == HorizontalAlign.LEFT ? position : (this.topConnectionAlign == HorizontalAlign.RIGHT ? connectionMaxLeft : position + (width - contentWidth) / 2));
        return this.restrictInt(relativeTopConnection + this.topConnectionOffset, 0, connectionMaxLeft);
    }

    private int calculateBottomConnection(int left, int position, int width, int contentWidth, int connectionMaxLeft) {
        int bottomConnection = this.bottomConnectionConnect == ConnectMode.CONTENT ? (this.bottomConnectionAlign == HorizontalAlign.LEFT ? left : (this.bottomConnectionAlign == HorizontalAlign.RIGHT ? left + contentWidth - 1 : left + contentWidth / 2)) : (this.bottomConnectionAlign == HorizontalAlign.LEFT ? position : (this.bottomConnectionAlign == HorizontalAlign.RIGHT ? connectionMaxLeft : position + (width - contentWidth) / 2));
        return this.restrictInt(bottomConnection + this.bottomConnectionOffset, 0, connectionMaxLeft);
    }

    private int restrictInt(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    @Override
    public int[] alignChildren(TreeNode parentNode, List<TreeNode> children, int position, Map<TreeNode, Integer> widthMap) {
        int[] result = new int[children.size()];
        int childrenCount = children.size();
        int childrenWidth = 0;
        boolean first = true;
        for (int i = 0; i < childrenCount; ++i) {
            TreeNode childNode = children.get(i);
            if (first) {
                first = false;
            } else {
                childrenWidth += this.gap;
            }
            int childWidth = widthMap.get(childNode);
            result[i] = position + childrenWidth;
            childrenWidth += childWidth;
        }
        int parentWidth = widthMap.get(parentNode);
        int offset = this.childrenAlign == HorizontalAlign.LEFT ? 0 : (this.childrenAlign == HorizontalAlign.RIGHT ? parentWidth - childrenWidth : (parentWidth - childrenWidth) / 2);
        if (offset > 0) {
            int i = 0;
            while (i < childrenCount) {
                int n = i++;
                result[n] = result[n] + offset;
            }
        }
        return result;
    }

    @Override
    public int collectWidths(Map<TreeNode, Integer> widthMap, TreeNode node) {
        int contentWidth = node.content().dimensions().width();
        int childrenWidth = 0;
        boolean first = true;
        List<TreeNode> children = node.children();
        children.removeAll(Collections.singleton(null));
        for (TreeNode childNode : children) {
            if (first) {
                first = false;
            } else {
                childrenWidth += this.gap;
            }
            childrenWidth += this.collectWidths(widthMap, childNode);
        }
        int nodeWidth = Math.max(contentWidth, childrenWidth);
        widthMap.put(node, nodeWidth);
        return nodeWidth;
    }

    public static class Builder {
        private HorizontalAlign contentAlign = HorizontalAlign.CENTER;
        private int contentOffset = 0;
        private ConnectMode topConnectionConnect = ConnectMode.CONTENT;
        private HorizontalAlign topConnectionAlign = HorizontalAlign.CENTER;
        private int topConnectionOffset = 0;
        private ConnectMode bottomConnectionConnect = ConnectMode.CONTENT;
        private HorizontalAlign bottomConnectionAlign = HorizontalAlign.CENTER;
        private int bottomConnectionOffset = 0;
        private HorizontalAlign childrenAlign = HorizontalAlign.CENTER;
        private int gap = 1;

        public Builder align(HorizontalAlign align) {
            this.contentAlign = align;
            this.topConnectionAlign = align;
            this.bottomConnectionAlign = align;
            this.childrenAlign = align;
            return this;
        }

        public Builder contentAlign(HorizontalAlign contentAlign) {
            this.contentAlign = contentAlign;
            return this;
        }

        public Builder contentOffset(int contentOffset) {
            this.contentOffset = contentOffset;
            return this;
        }

        public Builder topConnectionConnect(ConnectMode topConnectionConnect) {
            this.topConnectionConnect = topConnectionConnect;
            return this;
        }

        public Builder topConnectionAlign(HorizontalAlign topConnectionAlign) {
            this.topConnectionAlign = topConnectionAlign;
            return this;
        }

        public Builder topConnectionOffset(int topConnectionOffset) {
            this.topConnectionOffset = topConnectionOffset;
            return this;
        }

        public Builder bottomConnectionConnect(ConnectMode bottomConnectionConnect) {
            this.bottomConnectionConnect = bottomConnectionConnect;
            return this;
        }

        public Builder bottomConnectionAlign(HorizontalAlign bottomConnectionAlign) {
            this.bottomConnectionAlign = bottomConnectionAlign;
            return this;
        }

        public Builder bottomConnectionOffset(int bottomConnectionOffset) {
            this.bottomConnectionOffset = bottomConnectionOffset;
            return this;
        }

        public Builder childrenAlign(HorizontalAlign childrenAlign) {
            this.childrenAlign = childrenAlign;
            return this;
        }

        public Builder gap(int gap) {
            this.gap = gap;
            return this;
        }

        public DefaultAligner build() {
            return new DefaultAligner(this);
        }
    }

    public static enum ConnectMode {
        CONTENT,
        CONTEXT;

    }
}

