/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.printer.traditional;

import hu.webarticum.treeprinter.AnsiMode;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.decorator.TrackingTreeNodeDecorator;
import hu.webarticum.treeprinter.printer.TreePrinter;
import hu.webarticum.treeprinter.printer.traditional.Aligner;
import hu.webarticum.treeprinter.printer.traditional.DefaultAligner;
import hu.webarticum.treeprinter.printer.traditional.DefaultLiner;
import hu.webarticum.treeprinter.printer.traditional.Liner;
import hu.webarticum.treeprinter.printer.traditional.Placement;
import hu.webarticum.treeprinter.text.AnsiFormat;
import hu.webarticum.treeprinter.text.Dimensions;
import hu.webarticum.treeprinter.text.LineBuffer;
import hu.webarticum.treeprinter.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TraditionalTreePrinter
implements TreePrinter {
    public static final Aligner DEFAULT_ALIGNER = new DefaultAligner();
    public static final Liner DEFAULT_LINER = new DefaultLiner();
    private final Aligner aligner;
    private final Liner liner;
    private final boolean displayPlaceholders;
    private final AnsiMode ansiMode;

    public TraditionalTreePrinter() {
        this(DEFAULT_ALIGNER, DEFAULT_LINER);
    }

    public TraditionalTreePrinter(AnsiFormat ansiFormat) {
        this(DEFAULT_ALIGNER, new DefaultLiner(ansiFormat));
    }

    public TraditionalTreePrinter(AnsiMode ansiMode, AnsiFormat ansiFormat) {
        this(DEFAULT_ALIGNER, new DefaultLiner(ansiFormat), false, ansiMode);
    }

    public TraditionalTreePrinter(Aligner aligner) {
        this(aligner, DEFAULT_LINER);
    }

    public TraditionalTreePrinter(Liner liner) {
        this(DEFAULT_ALIGNER, liner);
    }

    public TraditionalTreePrinter(Aligner aligner, Liner liner) {
        this(aligner, liner, false);
    }

    public TraditionalTreePrinter(boolean displayPlaceholders) {
        this(DEFAULT_ALIGNER, DEFAULT_LINER, displayPlaceholders);
    }

    public TraditionalTreePrinter(Aligner aligner, Liner liner, boolean displayPlaceholders) {
        this(aligner, liner, displayPlaceholders, AnsiMode.AUTO);
    }

    public TraditionalTreePrinter(Aligner aligner, Liner liner, boolean displayPlaceholders, AnsiMode ansiMode) {
        this.aligner = aligner;
        this.liner = liner;
        this.displayPlaceholders = displayPlaceholders;
        this.ansiMode = ansiMode;
    }

    @Override
    public void print(TreeNode rootNode, Appendable out) {
        TrackingTreeNodeDecorator wrappedRootNode = new TrackingTreeNodeDecorator(rootNode);
        HashMap<TreeNode, Integer> widthMap = new HashMap<TreeNode, Integer>();
        int rootWidth = this.aligner.collectWidths(widthMap, wrappedRootNode);
        Map<TreeNode, Position> positionMap = new HashMap<TreeNode, Position>();
        Dimensions rootContentDimensions = wrappedRootNode.content().dimensions();
        Placement rootPlacement = this.aligner.alignNode(wrappedRootNode, 0, rootWidth, rootContentDimensions.width());
        Position rootPosition = new Position(0, 0, rootPlacement.bottomConnection(), rootPlacement.left(), rootContentDimensions.height());
        positionMap.put(wrappedRootNode, rootPosition);
        LineBuffer buffer = Util.createLineBuffer(out, this.ansiMode);
        buffer.write(0, rootPlacement.left(), wrappedRootNode.content());
        buffer.flush();
        while (!positionMap.isEmpty()) {
            positionMap = this.printNextGeneration(buffer, positionMap, widthMap);
        }
        buffer.flush();
    }

    private Map<TreeNode, Position> printNextGeneration(LineBuffer buffer, Map<TreeNode, Position> positionMap, Map<TreeNode, Integer> widthMap) {
        HashMap<TreeNode, Position> newPositionMap = new HashMap<TreeNode, Position>();
        ArrayList<Integer> childBottoms = new ArrayList<Integer>();
        for (Map.Entry<TreeNode, Position> entry : positionMap.entrySet()) {
            TreeNode node = entry.getKey();
            Position position = entry.getValue();
            this.handleNodeChildren(buffer, node, position, newPositionMap, widthMap, childBottoms);
        }
        if (!newPositionMap.isEmpty()) {
            int minimumChildBottom = Integer.MAX_VALUE;
            Iterator iterator = childBottoms.iterator();
            while (iterator.hasNext()) {
                int bottomValue = (Integer)iterator.next();
                if (bottomValue >= minimumChildBottom) continue;
                minimumChildBottom = bottomValue;
            }
            buffer.flush(minimumChildBottom);
        }
        return newPositionMap;
    }

    private void handleNodeChildren(LineBuffer buffer, TreeNode node, Position position, Map<TreeNode, Position> newPositionMap, Map<TreeNode, Integer> widthMap, List<Integer> childBottoms) {
        HashMap<TreeNode, Position> childrenPositionMap = new HashMap<TreeNode, Position>();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(node.children());
        if (!this.displayPlaceholders) {
            children.removeIf(TreeNode::isPlaceholder);
        }
        if (children.isEmpty()) {
            return;
        }
        int[] childrenAlign = this.aligner.alignChildren(node, children, position.col, widthMap);
        int childCount = children.size();
        ArrayList<Integer> childConnections = new ArrayList<Integer>(childCount);
        for (int i = 0; i < childCount; ++i) {
            int childCol = childrenAlign[i];
            TreeNode childNode = (TreeNode)children.get(i);
            int childWidth = widthMap.get(childNode);
            Dimensions childContentDimensions = childNode.content().dimensions();
            Placement childPlacement = this.aligner.alignNode(childNode, childCol, childWidth, childContentDimensions.width());
            Position childPositioning = new Position(position.row + position.height, childCol, childPlacement.bottomConnection(), childPlacement.left(), childContentDimensions.height());
            childrenPositionMap.put(childNode, childPositioning);
            childConnections.add(childPlacement.topConnection());
        }
        int connectionRows = this.liner.printConnections(buffer, position.row + position.height, position.connection, childConnections);
        for (Map.Entry childEntry : childrenPositionMap.entrySet()) {
            TreeNode childNode = (TreeNode)childEntry.getKey();
            Position childPositionItem = (Position)childEntry.getValue();
            childPositionItem.row += connectionRows;
            buffer.write(childPositionItem.row, childPositionItem.left, childNode.content());
            childBottoms.add(childPositionItem.row + childPositionItem.height);
        }
        newPositionMap.putAll(childrenPositionMap);
    }

    private class Position {
        int row;
        int col;
        int connection;
        int left;
        int height;

        Position(int row, int col, int connection, int left, int height) {
            this.row = row;
            this.col = col;
            this.connection = connection;
            this.left = left;
            this.height = height;
        }
    }
}

