/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.text;

import hu.webarticum.treeprinter.text.ConsoleText;
import hu.webarticum.treeprinter.text.TextUtil;

public class AnsiConsoleText
implements ConsoleText {
    private final String ansiText;
    private volatile String plainText = null;

    public AnsiConsoleText(String ansiText) {
        this(ansiText, true);
    }

    AnsiConsoleText(String ansiText, boolean clean) {
        this.ansiText = clean ? TextUtil.cleanAnsi(ansiText) : ansiText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String plain() {
        if (this.plainText == null) {
            AnsiConsoleText ansiConsoleText = this;
            synchronized (ansiConsoleText) {
                if (this.plainText == null) {
                    this.plainText = TextUtil.ansiToPlain(this.ansiText);
                }
            }
        }
        return this.plainText;
    }

    @Override
    public String ansi() {
        return this.ansiText;
    }

    @Override
    public ConsoleText concat(ConsoleText consoleText) {
        return new AnsiConsoleText(this.ansiText + consoleText.ansi(), false);
    }
}

