/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.text;

import hu.webarticum.treeprinter.AnsiMode;
import hu.webarticum.treeprinter.text.ConsoleText;
import hu.webarticum.treeprinter.text.LineMerger;
import hu.webarticum.treeprinter.text.PlainLineMerger;
import hu.webarticum.treeprinter.text.TextUtil;
import hu.webarticum.treeprinter.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LineBuffer {
    private final Appendable out;
    private final LineMerger lineMerger;
    private final AnsiMode ansiMode;
    private int flushedRowCount = 0;
    private List<String> lines = new ArrayList<String>();

    public LineBuffer(Appendable out) {
        this(out, new PlainLineMerger());
    }

    public LineBuffer(Appendable out, LineMerger lineMerger) {
        this(out, lineMerger, AnsiMode.AUTO);
    }

    public LineBuffer(Appendable out, LineMerger lineMerger, AnsiMode ansiMode) {
        this.out = out;
        this.lineMerger = lineMerger;
        this.ansiMode = ansiMode;
    }

    public void write(int row, int col, ConsoleText content) {
        ConsoleText[] textLines = TextUtil.linesOf(content);
        int lineCount = textLines.length;
        for (int i = 0; i < lineCount; ++i) {
            this.writeLine(row + i, col, Util.getStringContent(textLines[i], this.ansiMode));
        }
    }

    public void flush() {
        this.flush(this.flushedRowCount + this.lines.size());
    }

    public void flush(int untilRowIndex) {
        try {
            this.flushThrows(untilRowIndex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void flushThrows(int untilRowIndex) throws IOException {
        int deleteLineCount;
        if (untilRowIndex <= this.flushedRowCount) {
            return;
        }
        int currentLineCount = this.lines.size();
        if (currentLineCount <= (deleteLineCount = untilRowIndex - this.flushedRowCount)) {
            for (String line : this.lines) {
                this.out.append(line + "\n");
            }
            this.lines.clear();
        } else {
            for (int i = 0; i < deleteLineCount; ++i) {
                String line = this.lines.get(i);
                this.out.append(line + "\n");
            }
            this.lines = new ArrayList<String>(this.lines.subList(deleteLineCount, currentLineCount));
        }
        this.flushedRowCount = untilRowIndex;
    }

    private void writeLine(int row, int col, String textLine) {
        String originalLine;
        if (row < this.flushedRowCount) {
            return;
        }
        int lineIndex = row - this.flushedRowCount;
        int currentLineCount = this.lines.size();
        if (lineIndex < currentLineCount) {
            originalLine = this.lines.get(lineIndex);
        } else {
            for (int i = currentLineCount; i <= lineIndex; ++i) {
                this.lines.add("");
            }
            originalLine = "";
        }
        String newLine = this.lineMerger.merge(originalLine, col, textLine);
        this.lines.set(lineIndex, newLine);
    }
}

