/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.klaros;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.klaros.Messages;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KlarosTestResultPublisher
extends Recorder {
    private String config;
    private String env;
    private String sut;
    private String type = "junit";
    private String pathTestResults;
    private String url;

    @DataBoundConstructor
    public KlarosTestResultPublisher(String config, String env, String sut, String type, String pathTestResults, String url) {
        this.config = config;
        this.env = env;
        this.sut = sut;
        this.pathTestResults = pathTestResults;
        this.url = url;
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSut() {
        return this.sut;
    }

    public void setSut(String sut) {
        this.sut = sut;
    }

    public String getPathTestResults() {
        return this.pathTestResults;
    }

    public void setPathTestResults(String pathTestResults) {
        this.pathTestResults = pathTestResults;
    }

    public List<String> getUrls() {
        return KlarosTestResultPublisher.descriptor().getUrls();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean result;
        if (this.pathTestResults == null) {
            listener.getLogger().println("There are no test result to import!");
            result = false;
        } else {
            listener.getLogger().println("The test result(s) contained in target " + this.pathTestResults + " will be exported to the " + "Klaros-Testmanagement Server at " + this.getUrl(this.url) + ".");
            listener.getLogger().println("With parameters Project[" + this.config + "], Environment[" + this.env + "], SUT[" + this.sut + "] and Type[" + this.type + "].");
            FilePath ws = build.getWorkspace();
            if (ws == null) {
                listener.error("No workspace defined!");
                build.setResult(Result.FAILURE);
                result = false;
            } else {
                try {
                    FileCallableImplementation exporter = new FileCallableImplementation(listener);
                    ws.act((FilePath.FileCallable)exporter);
                }
                catch (IOException e) {
                    listener.getLogger().println("Failure to export test result(s).");
                    e.printStackTrace(listener.getLogger());
                }
                catch (InterruptedException e) {
                    listener.getLogger().println("Failure to export test result(s).");
                    e.printStackTrace(listener.getLogger());
                }
                listener.getLogger().println("Test result(s) successfully exported.");
                result = true;
            }
        }
        return result;
    }

    public String getUrl(String sourceURL) {
        String result = null;
        if (sourceURL == null) {
            List<String> urls = KlarosTestResultPublisher.descriptor().getUrls();
            if (urls.size() >= 1) {
                result = urls.get(0);
            }
            return result;
        }
        for (String j : KlarosTestResultPublisher.descriptor().getUrls()) {
            if (!j.equals(sourceURL)) continue;
            result = j;
            break;
        }
        return result;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return KlarosTestResultPublisher.descriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String PROJECT_CONFIG_HTML = "/plugin/klaros-testmanagement/help-projectConfig.html";
        private static final String URL_NAME = "url.name";
        private List<String> urls = new ArrayList<String>();

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.urls.clear();
            if (req.getParameterValues(URL_NAME) != null) {
                for (int i = 0; i < req.getParameterValues(URL_NAME).length; ++i) {
                    this.urls.add(req.getParameterValues(URL_NAME)[i]);
                    this.save();
                }
            }
            return super.configure(req, json);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return PROJECT_CONFIG_HTML;
        }

        public List<String> getUrls() {
            return this.urls;
        }

        public void setUrls(List<String> setUrls) {
            this.urls.clear();
            for (String url : setUrls) {
                this.urls.add(url);
            }
        }

        public FormValidation doCheckUrl(final String value) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String cooked = Util.fixEmpty((String)value);
                    if (cooked == null) {
                        return FormValidation.ok();
                    }
                    if (!value.endsWith("/")) {
                        cooked = cooked + '/';
                    }
                    FormValidation result = FormValidation.ok();
                    try {
                        result = this.findText(this.open(new URL(cooked)), "Klaros") ? FormValidation.ok() : FormValidation.error((String)"This is a valid URL but it doesn't look like Klaros-Testmanagement");
                    }
                    catch (IOException e) {
                        result = this.handleIOException(value, e);
                    }
                    return result;
                }
            }.check();
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateFileMask(value, false) : FormValidation.ok();
        }

        public FormValidation doCheckInstallation(@QueryParameter String value) throws IOException, ServletException {
            if (Util.fixEmpty((String)value) != null) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.ErrorMissingInstallation());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FileCallableImplementation
    implements FilePath.FileCallable<List<Integer>> {
        private static final long serialVersionUID = 1560913900801548965L;
        private final BuildListener listener;

        private FileCallableImplementation(BuildListener listener) {
            this.listener = listener;
        }

        public List<Integer> invoke(File baseDir, VirtualChannel channel) throws IOException {
            ArrayList<Integer> results = new ArrayList<Integer>();
            FileSet src = Util.createFileSet((File)baseDir, (String)KlarosTestResultPublisher.this.pathTestResults);
            DirectoryScanner ds = src.getDirectoryScanner();
            ds.scan();
            if (ds.getIncludedFilesCount() == 0) {
                this.listener.getLogger().println("No exportable files found");
                return results;
            }
            String targetUrl = KlarosTestResultPublisher.this.getUrl(KlarosTestResultPublisher.this.url);
            if (targetUrl != null) {
                String strURL = new StringBuffer(targetUrl).append("/seam/resource/rest/importer").toString();
                for (String f : ds.getIncludedFiles()) {
                    PutMethod put = new PutMethod(strURL);
                    String query = "config=" + KlarosTestResultPublisher.this.config + "&env=" + KlarosTestResultPublisher.this.env + "&sut=" + KlarosTestResultPublisher.this.sut + "&type=" + KlarosTestResultPublisher.this.type;
                    put.setQueryString(query);
                    File file = new File(baseDir, f);
                    try {
                        int result = this.executePut(file, put);
                        if (result != 200) {
                            StringBuffer msg = new StringBuffer().append("Export of ").append(file.getName()).append(" failed - Response status code: ").append(result).append(" for request URL: ").append(strURL).append("?").append(query);
                            this.listener.getLogger().println(msg.toString());
                            continue;
                        }
                        results.add(result);
                        this.listener.getLogger().println("Test result file " + file.getName() + " has been successfully exported.");
                    }
                    catch (Exception e) {
                        e.printStackTrace(this.listener.getLogger());
                    }
                }
            } else {
                this.listener.getLogger().println(KlarosTestResultPublisher.this.url + ": unable to locate this Klaros URL");
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executePut(File file, PutMethod put) throws HttpException, IOException {
            int result = 0;
            FileRequestEntity entity = new FileRequestEntity(file, "text/xml; charset=ISO-8859-1");
            put.setRequestEntity((RequestEntity)entity);
            HttpClient httpclient = new HttpClient();
            try {
                result = httpclient.executeMethod((HttpMethod)put);
            }
            finally {
                put.releaseConnection();
            }
            return result;
        }
    }
}

