/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.File;
import hudson.Util;
import hudson.plugins.starteam.StarTeamConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StarTeamChangeLogBuilder {
    public static boolean writeChangeLog(OutputStream aOutputStream, Collection<File> aChanges, StarTeamConnection aConnection) throws IOException {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
        dateFormat.setCalendar(cal);
        dateFormat.setLenient(false);
        OutputStreamWriter writer = new OutputStreamWriter(aOutputStream, Charset.forName("UTF-8"));
        PrintWriter printwriter = new PrintWriter(writer);
        printwriter.println("<?xml version='1.0' encoding='UTF-8'?>");
        printwriter.println("<changelog>");
        for (File change : aChanges) {
            printwriter.println("\t<entry>");
            printwriter.println("\t\t<fileName>" + change.getName() + "</fileName>");
            printwriter.println("\t\t<revisionNumber>" + change.getContentVersion() + "</revisionNumber>");
            Date aDate = change.getModifiedTime().createDate();
            printwriter.println("\t\t<date>" + Util.xmlEscape((String)dateFormat.format(aDate)) + "</date>");
            printwriter.println("\t\t<message>" + Util.xmlEscape((String)change.getComment()) + "</message>");
            printwriter.println("\t\t<user>" + aConnection.getUsername(change.getModifiedBy()) + "</user>");
            printwriter.println("\t</entry>");
        }
        printwriter.println("</changelog>");
        printwriter.close();
        return true;
    }
}

