/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamPollingActor
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = -5678102033953507247L;
    private String hostname;
    private int port;
    private String user;
    private String passwd;
    private String projectname;
    private String viewname;
    private String foldername;
    private final TaskListener listener;
    private final Date sinceDate;
    private final Date currentDate;
    private final StarTeamViewSelector config;

    public StarTeamPollingActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, StarTeamViewSelector config, Date sinceDate, Date currentDate, TaskListener listener) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.listener = listener;
        this.sinceDate = sinceDate;
        this.currentDate = currentDate;
        this.config = config;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
        if (this.sinceDate == null) {
            return false;
        }
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            connection.close();
            return false;
        }
        Date synchronizedSinceDate = connection.calculatePreviousDateWithTimeZoneCheck(this.sinceDate, this.currentDate);
        if (connection.findChangedFiles(f, this.listener.getLogger(), synchronizedSinceDate).isEmpty()) {
            connection.close();
            return false;
        }
        connection.close();
        return true;
    }
}

