/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.Folder;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.starteam.StarTeamChangeLogBuilder;
import hudson.plugins.starteam.StarTeamChangeSet;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamFilePoint;
import hudson.plugins.starteam.StarTeamFilePointFunctions;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import hudson.remoting.VirtualChannel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StarTeamCheckoutActor
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = -3748818546244161292L;
    private final FilePath changelog;
    private final BuildListener listener;
    private final String hostname;
    private final int port;
    private final String user;
    private final String passwd;
    private final String projectname;
    private final String viewname;
    private final String foldername;
    private final StarTeamViewSelector config;
    private final AbstractBuild build;

    public StarTeamCheckoutActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, StarTeamViewSelector config, FilePath changelogFile, BuildListener listener, AbstractBuild build) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.changelog = changelogFile;
        this.listener = listener;
        this.config = config;
        this.build = build;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        File filePointFile;
        Run lastBuild;
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            return false;
        }
        this.listener.getLogger().print("Computing change set ");
        Collection<StarTeamFilePoint> historicFilePoints = null;
        Run run = lastBuild = this.build == null ? null : this.build.getPreviousBuild();
        if (lastBuild != null && (filePointFile = new File(lastBuild.getRootDir(), "starteam-filepoints.csv")).exists()) {
            historicFilePoints = StarTeamFilePointFunctions.loadCollection(filePointFile);
        }
        try {
            Folder rootFolder = connection.getRootFolder();
            StarTeamChangeSet changeSet = connection.computeChangeSet(rootFolder, workspace, historicFilePoints, this.listener.getLogger());
            this.listener.getLogger().println("performing checkout ...");
            File buildDir = this.build != null ? this.build.getRootDir() : workspace;
            connection.checkOut(changeSet, this.listener.getLogger(), buildDir);
            this.listener.getLogger().println("creating change log file ");
            try {
                this.createChangeLog(changeSet, workspace, this.changelog, this.listener, connection);
            }
            catch (InterruptedException e) {
                this.listener.getLogger().println("unable to create changelog file " + e.getMessage());
            }
        }
        catch (StarTeamSCMException e1) {
            e1.printStackTrace(this.listener.getLogger());
        }
        connection.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createChangeLog(StarTeamChangeSet changes, File aRootFile, FilePath aChangelogFile, BuildListener aListener, StarTeamConnection aConnection) throws IOException, InterruptedException {
        if (changes == null) {
            this.listener.getLogger().println("last build date is null, creating an empty change log file");
            this.createEmptyChangeLog(aChangelogFile, aListener, "log");
            return true;
        }
        BufferedOutputStream os = new BufferedOutputStream(aChangelogFile.write());
        boolean created = false;
        try {
            created = StarTeamChangeLogBuilder.writeChangeLog(os, changes);
        }
        catch (Exception ex) {
            this.listener.getLogger().println("change log creation failed due to unexpected error : " + ex.getMessage());
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(aChangelogFile, aListener, "log");
        }
        return true;
    }

    protected final boolean createEmptyChangeLog(FilePath aChangelogFile, BuildListener aListener, String aRootTag) throws InterruptedException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(aChangelogFile.write(), Charset.forName("UTF-8"));
            PrintWriter printwriter = new PrintWriter(writer);
            printwriter.write("<" + aRootTag + "/>");
            printwriter.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(aListener.error(e.getMessage()));
            return false;
        }
    }
}

