/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.Label;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import hudson.plugins.starteam.StarTeamSCMException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StarTeamViewSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String configInfo;
    private final ConfigType configType;
    private final DateFormat df = new SimpleDateFormat("yyyy/M/d HH:mm:ss");

    public StarTeamViewSelector(String configInfo, String configType) throws ParseException {
        this.configInfo = configInfo;
        ConfigType result = ConfigType.CURRENT;
        if (configType != null) {
            try {
                result = ConfigType.valueOf(configType.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        this.configType = result;
        if (this.configType == ConfigType.TIME) {
            this.df.parse(configInfo);
        }
    }

    public StarTeamViewSelector(Date time) {
        if (time != null) {
            this.configType = ConfigType.TIME;
            this.configInfo = this.df.format(time);
        } else {
            this.configType = ConfigType.CURRENT;
            this.configInfo = null;
        }
    }

    public View configView(View baseView) throws StarTeamSCMException, ParseException {
        ViewConfiguration configuration;
        if (this.configInfo != null && !this.configInfo.isEmpty()) {
            switch (this.configType) {
                case CURRENT: {
                    configuration = ViewConfiguration.createTip();
                    break;
                }
                case LABEL: {
                    int labelId = StarTeamViewSelector.findLabelInView(baseView, this.configInfo);
                    configuration = ViewConfiguration.createFromLabel((int)labelId);
                    break;
                }
                case PROMOTION: {
                    Integer promotionStateId = StarTeamViewSelector.findPromotionStateInView(baseView, this.configInfo);
                    if (promotionStateId != null) {
                        configuration = ViewConfiguration.createFromPromotionState((int)promotionStateId);
                        break;
                    }
                    configuration = ViewConfiguration.createTip();
                    break;
                }
                case TIME: {
                    Date effectiveDate = this.df.parse(this.configInfo);
                    configuration = ViewConfiguration.createFromTime((OLEDate)new OLEDate(effectiveDate));
                    break;
                }
                default: {
                    throw new StarTeamSCMException("Could not construct view - no configuration provided");
                }
            }
        } else {
            configuration = ViewConfiguration.createTip();
        }
        return new View(baseView, configuration);
    }

    private static int findLabelInView(View view, String labelname) throws StarTeamSCMException {
        for (Label label : view.getLabels()) {
            if (!labelname.equals(label.getName())) continue;
            return label.getID();
        }
        throw new StarTeamSCMException("Couldn't find label [" + labelname + "] in view " + view.getName());
    }

    private static Integer findPromotionStateInView(View view, String promotionState) throws StarTeamSCMException {
        for (PromotionState ps : view.getPromotionModel().getPromotionStates()) {
            if (!promotionState.equals(ps.getName())) continue;
            if (ps.getLabelID() == -1) {
                return null;
            }
            return ps.getObjectID();
        }
        throw new StarTeamSCMException("Couldn't find promotion state " + promotionState + " in view " + view.getName());
    }

    public String getConfigInfo() {
        return this.configInfo;
    }

    public String getConfigType() {
        return this.configType.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConfigType {
        CURRENT,
        LABEL,
        TIME,
        PROMOTION;

    }
}

