/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;

class AppendCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "APPEND";
    public static final String ARGS = "<mailbox> [<flag_list>] [<date_time>] literal";
    private AppendCommandParser parser = new AppendCommandParser();

    AppendCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        Date datetime;
        String mailboxName = this.parser.mailbox(request);
        Flags flags = this.parser.optionalAppendFlags(request);
        if (flags == null) {
            flags = new Flags();
        }
        if ((datetime = this.parser.optionalDateTime(request)) == null) {
            datetime = new Date();
        }
        MimeMessage message = this.parser.mimeMessage(request);
        this.parser.endLine(request);
        MailFolder folder = null;
        try {
            folder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        folder.appendMessage(message, flags, datetime);
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    class FixedLengthInputStream
    extends FilterInputStream {
        private long pos;
        private long length;

        public FixedLengthInputStream(InputStream in, long length) {
            super(in);
            this.pos = 0L;
            this.length = length;
        }

        public int read() throws IOException {
            if (this.pos >= this.length) {
                return -1;
            }
            ++this.pos;
            return super.read();
        }

        public int read(byte[] b) throws IOException {
            if (this.pos >= this.length) {
                return -1;
            }
            if (this.pos + (long)b.length >= this.length) {
                this.pos = this.length;
                return super.read(b, 0, (int)(this.length - this.pos));
            }
            this.pos += (long)b.length;
            return super.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            throw new IOException("Not implemented");
        }

        public long skip(long n) throws IOException {
            throw new IOException("Not implemented");
        }

        public int available() throws IOException {
            return super.available();
        }

        public void close() throws IOException {
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() throws IOException {
            throw new IOException("mark not supported");
        }

        public boolean markSupported() {
            return false;
        }
    }

    private class AppendCommandParser
    extends CommandParser {
        private AppendCommandParser() {
        }

        public Flags optionalAppendFlags(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextWordChar();
            if (next == '(') {
                return this.flagList(request);
            }
            return null;
        }

        public Date optionalDateTime(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextWordChar();
            if (next == '\"') {
                return this.dateTime(request);
            }
            return null;
        }

        public MimeMessage mimeMessage(ImapRequestLineReader request) throws ProtocolException {
            request.nextWordChar();
            String mailString = this.consumeLiteral(request);
            try {
                return GreenMailUtil.instance().newMimeMessage(mailString);
            }
            catch (Exception e) {
                throw new ProtocolException("UnexpectedException: " + e.getMessage());
            }
        }
    }
}

