/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.foedus.util.Quittable;
import com.icegreen.greenmail.foedus.util.StreamUtils;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class Pop3Connection {
    Quittable _handler;
    private static final int TIMEOUT_MILLIS = 30000;
    Socket _socket;
    InetAddress _clientAddress;
    BufferedReader _in;
    InternetPrintWriter _out;

    public Pop3Connection(Quittable handler, Socket socket) throws IOException {
        this.configureSocket(socket);
        this.configureStreams();
        this._handler = handler;
    }

    private void configureStreams() throws IOException {
        OutputStream o = this._socket.getOutputStream();
        InputStream i = this._socket.getInputStream();
        this._out = new InternetPrintWriter(o, true);
        this._in = new BufferedReader(new InputStreamReader(i));
    }

    private void configureSocket(Socket socket) throws SocketException {
        this._socket = socket;
        this._socket.setSoTimeout(30000);
        this._clientAddress = this._socket.getInetAddress();
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public void quit() {
        this._handler.quit();
    }

    public void println(String line) {
        System.out.println("S: " + line);
        this._out.print(line);
        this.println();
    }

    public void println() {
        this._out.print("\r\n");
        this._out.flush();
    }

    public void print(Reader in) throws IOException {
        StreamUtils.copy(in, this._out);
        this._out.flush();
    }

    public String readLine() throws IOException {
        String line = this._in.readLine();
        System.out.println("C: " + line);
        return line;
    }

    public String getClientAddress() {
        return this._clientAddress.toString();
    }
}

