/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3.commands;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.mail.Part;

public class TopCommand
extends Pop3Command {
    public boolean isValidForState(Pop3State state) {
        return state.isAuthenticated();
    }

    public void execute(Pop3Connection conn, Pop3State state, String cmd) {
        try {
            MailFolder inbox = state.getFolder();
            String[] cmdLine = cmd.split(" ");
            if (cmdLine.length < 3) {
                throw new IllegalArgumentException("range and line count required");
            }
            String msgNumStr = cmdLine[1];
            List msgList = inbox.getMessages(new MsgRangeFilter(msgNumStr, false));
            if (msgList.size() != 1) {
                conn.println("-ERR no such message");
                return;
            }
            SimpleStoredMessage msg = (SimpleStoredMessage)msgList.get(0);
            int numLines = Integer.parseInt(cmdLine[2]);
            BufferedReader in = new BufferedReader(new StringReader(GreenMailUtil.instance().getWholeMessage((Part)msg.getMimeMessage())));
            conn.println("+OK");
            this.copyHeaders(in, conn);
            this.copyLines(in, conn, numLines);
            in.close();
            conn.println(".");
        }
        catch (Exception e) {
            conn.println("-ERR " + e);
        }
    }

    void copyHeaders(BufferedReader in, Pop3Connection conn) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            conn.println(line);
            if (!"".equals(line)) continue;
            break;
        }
    }

    void copyLines(BufferedReader in, Pop3Connection conn, int numLines) throws IOException {
        String line;
        for (int count = 0; (line = in.readLine()) != null && count < numLines; ++count) {
            conn.println(line);
        }
    }
}

