/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.foedus.util.Quittable;
import com.icegreen.greenmail.foedus.util.Workspace;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.smtp.commands.SmtpCommandRegistry;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

class SmtpHandler
implements Quittable {
    SmtpCommandRegistry _registry;
    SmtpManager _manager;
    Workspace _workspace;
    SmtpConnection _conn;
    SmtpState _state;
    boolean _quitting;
    String _currentLine;

    public SmtpHandler(SmtpCommandRegistry registry, SmtpManager manager, Workspace workspace) {
        this._registry = registry;
        this._manager = manager;
        this._workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) throws IOException {
        this._conn = new SmtpConnection(this, socket);
        this._state = new SmtpState(this._workspace);
        try {
            this._quitting = false;
            this.sendGreetings();
            while (!this._quitting) {
                this.handleCommand();
            }
        }
        catch (SocketTimeoutException ste) {
            this._conn.println("421 Service shutting down and closing transmission channel");
        }
        catch (Exception exception) {
        }
        finally {
            this._state.clearMessage();
        }
    }

    protected void sendGreetings() {
        this._conn.println("220 " + this._conn.getServerGreetingsName() + " GreenMail SMTP Service Ready");
    }

    protected void handleCommand() throws IOException {
        this._currentLine = this._conn.readLine();
        if (this._currentLine == null) {
            this.quit();
            return;
        }
        if (!this.commandLegalSize()) {
            return;
        }
        String commandName = this._currentLine.substring(0, 4).toUpperCase();
        SmtpCommand command = this._registry.getCommand(commandName);
        if (command == null) {
            this._conn.println("500 Command not recognized");
            return;
        }
        command.execute(this._conn, this._state, this._manager, this._currentLine);
    }

    private boolean commandLegalSize() {
        if (this._currentLine.length() < 4) {
            this._conn.println("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this._currentLine.length() > 4 && this._currentLine.charAt(4) != ' ') {
            this._conn.println("500 Invalid command. Must be 4 characters");
            return false;
        }
        if (this._currentLine.length() > 1000) {
            this._conn.println("500 Command too long.  1000 character maximum.");
            return false;
        }
        return true;
    }

    public void quit() {
        this._quitting = true;
    }
}

