/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.Service;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.MimeMessage;

public class Servers {
    Managers managers = new Managers();
    HashMap services = new HashMap();

    public Servers(ServerSetup config) {
        this(new ServerSetup[]{config});
    }

    public Servers(ServerSetup[] config) {
        for (int i = 0; i < config.length; ++i) {
            ServerSetup setup = config[i];
            if (this.services.containsKey(setup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + setup.getProtocol() + "' was found at least twice in the array");
            }
            String protocol = setup.getProtocol();
            if (protocol.startsWith("smtp")) {
                this.services.put(protocol, new SmtpServer(setup, this.managers));
                continue;
            }
            if (protocol.startsWith("pop3")) {
                this.services.put(protocol, new Pop3Server(setup, this.managers));
                continue;
            }
            if (!protocol.startsWith("imap")) continue;
            this.services.put(protocol, new ImapServer(setup, this.managers));
        }
    }

    public void start() {
        Iterator it = this.services.values().iterator();
        while (it.hasNext()) {
            Service service = (Service)it.next();
            service.startService(null);
        }
    }

    public void stop() {
        Iterator it = this.services.values().iterator();
        while (it.hasNext()) {
            Service service = (Service)it.next();
            service.stopService(null);
        }
    }

    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    public Managers getManagers() {
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForIncomingEmail(long timeout, int emailCount) throws InterruptedException {
        SmtpManager.WaitObject o = this.managers.getSmtpManager().createAndAddNewWaitObject(emailCount);
        if (null == o) {
            return true;
        }
        SmtpManager.WaitObject waitObject = o;
        synchronized (waitObject) {
            long t0 = System.currentTimeMillis();
            while (!o.isArrived()) {
                o.wait(timeout);
                if (System.currentTimeMillis() - t0 <= timeout) continue;
                return false;
            }
        }
        return true;
    }

    public boolean waitForIncomingEmail(int emailCount) throws InterruptedException {
        return this.waitForIncomingEmail(5000L, emailCount);
    }

    public MimeMessage[] getReceivedMessages() {
        List msgs = this.managers.getImapHostManager().getAllMessages();
        MimeMessage[] ret = new MimeMessage[msgs.size()];
        for (int i = 0; i < msgs.size(); ++i) {
            SimpleStoredMessage simpleStoredMessage = (SimpleStoredMessage)msgs.get(i);
            ret[i] = simpleStoredMessage.getMimeMessage();
        }
        return ret;
    }

    public GreenMailUser setUser(String email, String password) {
        return this.setUser(email, email, password);
    }

    public GreenMailUser setUser(String email, String login, String password) {
        GreenMailUser user = this.managers.getUserManager().getUser(email);
        if (null == user) {
            try {
                this.managers.getUserManager().createUser(email, login, password);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
        } else {
            user.setPassword(password);
        }
        return user;
    }

    public void setUsers(Properties users) {
        Iterator<Object> it = users.keySet().iterator();
        while (it.hasNext()) {
            String email = (String)it.next();
            String password = users.getProperty(email);
            this.setUser(email, email, password);
        }
    }

    public GreenMailUtil util() {
        return GreenMailUtil.instance();
    }
}

