/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.foedus.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class StreamUtils {
    public static String toString(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        reader.close();
    }

    public static Reader limit(Reader reader, long l) {
        return new LimitedReader(reader, l);
    }

    public static Reader splice(Reader reader, Reader reader2) {
        return new SpliceReader(reader, reader2);
    }

    private static class LimitedReader
    extends Reader {
        Reader _in;
        long _maxLen;
        long _lenRead;

        public LimitedReader(Reader reader, long l) {
            this._in = reader;
            this._maxLen = l;
        }

        public void close() {
        }

        public int read() throws IOException {
            if (this._lenRead < this._maxLen) {
                ++this._lenRead;
                return this._in.read();
            }
            return -1;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this._lenRead < this._maxLen) {
                int n3 = (int)Math.min(this._maxLen - this._lenRead, (long)n2);
                int n4 = this._in.read(cArray, n, n3);
                this._lenRead += (long)n4;
                return n4;
            }
            return -1;
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }
    }

    private static class SpliceReader
    extends Reader {
        Reader _one;
        Reader _two;
        boolean oneFinished;

        public SpliceReader(Reader reader, Reader reader2) {
            this._one = reader;
            this._two = reader2;
        }

        public void close() throws IOException {
            this._one.close();
            this._two.close();
        }

        public int read() throws IOException {
            if (this.oneFinished) {
                return this._two.read();
            }
            int n = this._one.read();
            if (n == -1) {
                this.oneFinished = true;
                return this.read();
            }
            return n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.oneFinished) {
                return this._two.read(cArray, n, n2);
            }
            int n3 = this._one.read(cArray, n, n2);
            if (n3 == -1) {
                this.oneFinished = true;
                return this.read(cArray, n, n2);
            }
            return n3;
        }

        public int read(char[] cArray) throws IOException {
            if (this.oneFinished) {
                return this._two.read(cArray);
            }
            int n = this._one.read(cArray);
            if (n == -1) {
                this.oneFinished = true;
                return this.read(cArray);
            }
            return n;
        }
    }
}

