/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapRequestHandler;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionImpl;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

public class ImapHandler
extends Thread
implements ImapConstants {
    private ImapRequestHandler requestHandler = new ImapRequestHandler();
    private ImapSession session;
    private Socket socket;
    private BufferedReader in;
    private InputStream ins;
    private InternetPrintWriter out;
    private OutputStream outs;
    UserManager userManager;
    private ImapHostManager imapHost;

    public ImapHandler(UserManager userManager, ImapHostManager imapHostManager, Socket socket) {
        this.userManager = userManager;
        this.imapHost = imapHostManager;
        this.socket = socket;
    }

    public void forceConnectionClose(String string) {
        ImapResponse imapResponse = new ImapResponse(this.outs);
        imapResponse.byeResponse(string);
        this.resetHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = "";
        String string2 = "";
        try {
            this.ins = this.socket.getInputStream();
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ASCII"), 512);
            string2 = this.socket.getInetAddress().getHostAddress();
            string = this.socket.getInetAddress().getHostName();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            this.outs = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
            this.out = new InternetPrintWriter(this.outs, true);
            ImapResponse imapResponse = new ImapResponse(this.outs);
            StringBuffer stringBuffer = new StringBuffer(256).append("IMAP4rev1").append(" Server ").append("GreenMail").append(" ready");
            imapResponse.okResponse(null, stringBuffer.toString());
            this.session = new ImapSessionImpl(this.imapHost, this.userManager, this, this.socket.getInetAddress().getHostName(), this.socket.getInetAddress().getHostAddress());
            while (this.requestHandler.handleRequest(this.ins, this.outs, this.session)) {
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.resetHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetHandler() {
        try {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.in = null;
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.out = null;
        }
        try {
            if (this.outs != null) {
                this.outs.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.outs = null;
        }
        this.session = null;
    }

    private void stat() {
    }

    final void writeLoggedFlushedResponse(String string) {
        this.out.println(string);
        this.out.flush();
    }

    final void writeLoggedResponse(String string) {
        this.out.println(string);
    }
}

