/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.user.GreenMailUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ImapHostManagerImpl
implements ImapHostManager,
ImapConstants {
    private Store store;
    private MailboxSubscriptions subscriptions;

    public ImapHostManagerImpl() {
        this.store = new InMemoryStore();
        this.subscriptions = new MailboxSubscriptions();
    }

    public ImapHostManagerImpl(Store store) {
        this.store = store;
        this.subscriptions = new MailboxSubscriptions();
    }

    public List getAllMessages() {
        ArrayList arrayList = new ArrayList();
        try {
            Collection collection = this.store.listMailboxes("*");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MailFolder mailFolder = (MailFolder)iterator.next();
                List list = mailFolder.getMessages();
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
        catch (FolderException folderException) {
            throw new RuntimeException(folderException);
        }
        return arrayList;
    }

    public char getHierarchyDelimiter() {
        return '.';
    }

    public MailFolder getFolder(GreenMailUser greenMailUser, String string) {
        String string2 = this.getQualifiedMailboxName(greenMailUser, string);
        MailFolder mailFolder = this.store.getMailbox(string2);
        return this.checkViewable(mailFolder);
    }

    public MailFolder getFolder(GreenMailUser greenMailUser, String string, boolean bl) throws FolderException {
        MailFolder mailFolder = this.getFolder(greenMailUser, string);
        if (bl && mailFolder == null) {
            throw new FolderException("No such store.");
        }
        return mailFolder;
    }

    private MailFolder checkViewable(MailFolder mailFolder) {
        return mailFolder;
    }

    public MailFolder getInbox(GreenMailUser greenMailUser) throws FolderException {
        return this.getFolder(greenMailUser, "INBOX");
    }

    public void createPrivateMailAccount(GreenMailUser greenMailUser) throws FolderException {
        MailFolder mailFolder = this.store.getMailbox("#mail");
        MailFolder mailFolder2 = this.store.createMailbox(mailFolder, greenMailUser.getQualifiedMailboxName(), false);
        this.store.createMailbox(mailFolder2, "INBOX", true);
    }

    public MailFolder createMailbox(GreenMailUser greenMailUser, String string) throws AuthorizationException, FolderException {
        String string2 = this.getQualifiedMailboxName(greenMailUser, string);
        if (this.store.getMailbox(string2) != null) {
            throw new FolderException("Mailbox already exists.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, HIERARCHY_DELIMITER);
        if (stringTokenizer.countTokens() < 2) {
            throw new FolderException("Cannot create store at namespace level.");
        }
        String string3 = stringTokenizer.nextToken();
        MailFolder mailFolder = this.store.getMailbox(string3);
        if (mailFolder == null) {
            throw new FolderException("Invalid namespace.");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            MailFolder mailFolder2 = this.store.getMailbox(mailFolder, string4);
            if (mailFolder2 == null) {
                boolean bl = !stringTokenizer.hasMoreTokens();
                mailFolder2 = this.store.createMailbox(mailFolder, string4, bl);
            }
            mailFolder = mailFolder2;
        }
        return mailFolder;
    }

    public void deleteMailbox(GreenMailUser greenMailUser, String string) throws FolderException, AuthorizationException {
        MailFolder mailFolder = this.getFolder(greenMailUser, string, true);
        if (this.store.getChildren(mailFolder).isEmpty()) {
            mailFolder.deleteAllMessages();
            mailFolder.signalDeletion();
            this.store.deleteMailbox(mailFolder);
        } else if (mailFolder.isSelectable()) {
            mailFolder.deleteAllMessages();
            this.store.setSelectable(mailFolder, false);
        } else {
            throw new FolderException("Can't delete a non-selectable store with children.");
        }
    }

    public void renameMailbox(GreenMailUser greenMailUser, String string, String string2) throws FolderException, AuthorizationException {
        MailFolder mailFolder = this.getFolder(greenMailUser, string, true);
        String string3 = this.getQualifiedMailboxName(greenMailUser, "INBOX");
        if (string3.equals(mailFolder.getFullName())) {
            MailFolder mailFolder2 = mailFolder;
            MailFolder mailFolder3 = this.createMailbox(greenMailUser, string2);
            long[] lArray = mailFolder2.getMessageUids();
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                mailFolder2.copyMessage(l, mailFolder3);
            }
            mailFolder2.deleteAllMessages();
            return;
        }
        this.store.renameMailbox(mailFolder, string2);
    }

    public Collection listSubscribedMailboxes(GreenMailUser greenMailUser, String string) throws FolderException {
        return this.listMailboxes(greenMailUser, string, true);
    }

    public Collection listMailboxes(GreenMailUser greenMailUser, String string) throws FolderException {
        return this.listMailboxes(greenMailUser, string, false);
    }

    private Collection listMailboxes(GreenMailUser greenMailUser, String string, boolean bl) throws FolderException {
        ArrayList<MailFolder> arrayList = new ArrayList<MailFolder>();
        String string2 = this.getQualifiedMailboxName(greenMailUser, string);
        Iterator iterator = this.store.listMailboxes(string2).iterator();
        while (iterator.hasNext()) {
            MailFolder mailFolder = (MailFolder)iterator.next();
            if (bl && !this.subscriptions.isSubscribed(greenMailUser, mailFolder)) {
                mailFolder = null;
            }
            if ((mailFolder = this.checkViewable(mailFolder)) == null) continue;
            arrayList.add(mailFolder);
        }
        return arrayList;
    }

    public void subscribe(GreenMailUser greenMailUser, String string) throws FolderException {
        MailFolder mailFolder = this.getFolder(greenMailUser, string, true);
        this.subscriptions.subscribe(greenMailUser, mailFolder);
    }

    public void unsubscribe(GreenMailUser greenMailUser, String string) throws FolderException {
        MailFolder mailFolder = this.getFolder(greenMailUser, string, true);
        this.subscriptions.unsubscribe(greenMailUser, mailFolder);
    }

    private String getQualifiedMailboxName(GreenMailUser greenMailUser, String string) {
        String string2 = greenMailUser.getQualifiedMailboxName();
        if ("INBOX".equalsIgnoreCase(string)) {
            return "#mail" + HIERARCHY_DELIMITER + string2 + HIERARCHY_DELIMITER + "INBOX";
        }
        if (string.startsWith(NAMESPACE_PREFIX)) {
            return string;
        }
        if (string.length() == 0) {
            return "#mail" + HIERARCHY_DELIMITER + string2;
        }
        return "#mail" + HIERARCHY_DELIMITER + string2 + HIERARCHY_DELIMITER + string;
    }

    private class MailboxSubscriptions {
        private Map userSubs = new HashMap();

        private MailboxSubscriptions() {
        }

        void subscribe(GreenMailUser greenMailUser, MailFolder mailFolder) throws FolderException {
            this.getUserSubs(greenMailUser).add(mailFolder.getFullName());
        }

        void unsubscribe(GreenMailUser greenMailUser, MailFolder mailFolder) throws FolderException {
            this.getUserSubs(greenMailUser).remove(mailFolder.getFullName());
        }

        boolean isSubscribed(GreenMailUser greenMailUser, MailFolder mailFolder) {
            return this.getUserSubs(greenMailUser).contains(mailFolder.getFullName());
        }

        private Collection getUserSubs(GreenMailUser greenMailUser) {
            ArrayList arrayList = (ArrayList)this.userSubs.get(greenMailUser.getLogin());
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.userSubs.put(greenMailUser.getLogin(), arrayList);
            }
            return arrayList;
        }
    }
}

