/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.imap.commands.ImapCommandFactory;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImapRequestHandler {
    private ImapCommandFactory imapCommands = new ImapCommandFactory();
    private CommandParser parser = new CommandParser();
    private static final String REQUEST_SYNTAX = "Protocol Error: Was expecting <tag SPACE command [arguments]>";

    public boolean handleRequest(InputStream inputStream, OutputStream outputStream, ImapSession imapSession) throws ProtocolException {
        ImapRequestLineReader imapRequestLineReader = new ImapRequestLineReader(inputStream, outputStream);
        try {
            imapRequestLineReader.nextChar();
        }
        catch (ProtocolException protocolException) {
            return false;
        }
        ImapResponse imapResponse = new ImapResponse(outputStream);
        this.doProcessRequest(imapRequestLineReader, imapResponse, imapSession);
        imapRequestLineReader.consumeLine();
        return true;
    }

    private void doProcessRequest(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) {
        String string = null;
        String string2 = null;
        try {
            string = this.parser.tag(imapRequestLineReader);
        }
        catch (ProtocolException protocolException) {
            imapResponse.badResponse(REQUEST_SYNTAX);
            return;
        }
        imapResponse.setTag(string);
        try {
            string2 = this.parser.atom(imapRequestLineReader);
        }
        catch (ProtocolException protocolException) {
            imapResponse.commandError(REQUEST_SYNTAX);
            return;
        }
        ImapCommand imapCommand = this.imapCommands.getCommand(string2);
        if (imapCommand == null) {
            imapResponse.commandError("Invalid command.");
            return;
        }
        if (!imapCommand.validForState(imapSession.getState())) {
            imapResponse.commandFailed(imapCommand, "Command not valid in this state");
            return;
        }
        imapCommand.process(imapRequestLineReader, imapResponse, imapSession);
    }
}

