/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImapRequestLineReader {
    private InputStream input;
    private OutputStream output;
    private boolean nextSeen = false;
    private char nextChar;

    ImapRequestLineReader(InputStream inputStream, OutputStream outputStream) {
        this.input = inputStream;
        this.output = outputStream;
    }

    public char nextWordChar() throws ProtocolException {
        char c = this.nextChar();
        while (c == ' ') {
            this.consume();
            c = this.nextChar();
        }
        if (c == '\r' || c == '\n') {
            throw new ProtocolException("Missing argument.");
        }
        return c;
    }

    public char nextChar() throws ProtocolException {
        if (!this.nextSeen) {
            int n = -1;
            try {
                n = this.input.read();
            }
            catch (IOException iOException) {
                throw new ProtocolException("Error reading from stream.");
            }
            if (n == -1) {
                throw new ProtocolException("Unexpected end of stream.");
            }
            this.nextSeen = true;
            this.nextChar = (char)n;
        }
        return this.nextChar;
    }

    public void eol() throws ProtocolException {
        char c = this.nextChar();
        while (c == ' ') {
            this.consume();
            c = this.nextChar();
        }
        if (c == '\r') {
            this.consume();
            c = this.nextChar();
        }
        if (c != '\n') {
            throw new ProtocolException("Expected end-of-line, found more characters.");
        }
    }

    public char consume() throws ProtocolException {
        char c = this.nextChar();
        this.nextSeen = false;
        this.nextChar = '\u0000';
        return c;
    }

    public void read(byte[] byArray) throws ProtocolException {
        try {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                n = 0;
                n = this.input.read(byArray, i, byArray.length - i);
                if (n != -1) continue;
                throw new ProtocolException("Unexpectd end of stream.");
            }
            this.nextSeen = false;
            this.nextChar = '\u0000';
        }
        catch (IOException iOException) {
            throw new ProtocolException("Error reading from stream.");
        }
    }

    public void commandContinuationRequest() throws ProtocolException {
        try {
            this.output.write(43);
            this.output.write(13);
            this.output.write(10);
            this.output.flush();
        }
        catch (IOException iOException) {
            throw new ProtocolException("Unexpected exception in sending command continuation request.");
        }
    }

    public void consumeLine() throws ProtocolException {
        char c = this.nextChar();
        while (c != '\n') {
            this.consume();
            c = this.nextChar();
        }
        this.consume();
    }
}

