/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.OutputStream;
import javax.mail.Flags;

public class ImapResponse
implements ImapConstants {
    private InternetPrintWriter writer;
    private String tag = "*";

    public ImapResponse(OutputStream outputStream) {
        this.writer = new InternetPrintWriter(outputStream, true);
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public void commandComplete(ImapCommand imapCommand) {
        this.commandComplete(imapCommand, null);
    }

    public void commandComplete(ImapCommand imapCommand, String string) {
        this.tag();
        this.message("OK");
        this.responseCode(string);
        this.commandName(imapCommand);
        this.message("completed.");
        this.end();
    }

    public void commandFailed(ImapCommand imapCommand, String string) {
        this.commandFailed(imapCommand, null, string);
    }

    public void commandFailed(ImapCommand imapCommand, String string, String string2) {
        this.tag();
        this.message("NO");
        this.responseCode(string);
        this.commandName(imapCommand);
        this.message("failed.");
        this.message(string2);
        this.end();
    }

    public void commandError(String string) {
        this.tag();
        this.message("BAD");
        this.message(string);
        this.end();
    }

    public void badResponse(String string) {
        this.untagged();
        this.message("BAD");
        this.message(string);
        this.end();
    }

    public void okResponse(String string, String string2) {
        this.untagged();
        this.message("OK");
        this.responseCode(string);
        this.message(string2);
        this.end();
    }

    public void flagsResponse(Flags flags) {
        this.untagged();
        this.message("FLAGS");
        this.message(MessageFlags.format(flags));
        this.end();
    }

    public void existsResponse(int n) {
        this.untagged();
        this.message(n);
        this.message("EXISTS");
        this.end();
    }

    public void recentResponse(int n) {
        this.untagged();
        this.message(n);
        this.message("RECENT");
        this.end();
    }

    public void expungeResponse(int n) {
        this.untagged();
        this.message(n);
        this.message("EXPUNGE");
        this.end();
    }

    public void fetchResponse(int n, String string) {
        this.untagged();
        this.message(n);
        this.message("FETCH");
        this.message("(" + string + ")");
        this.end();
    }

    public void commandResponse(ImapCommand imapCommand, String string) {
        this.untagged();
        this.commandName(imapCommand);
        this.message(string);
        this.end();
    }

    public void taggedResponse(String string) {
        this.tag();
        this.message(string);
        this.end();
    }

    public void untaggedResponse(String string) {
        this.untagged();
        this.message(string);
        this.end();
    }

    public void byeResponse(String string) {
        this.untaggedResponse("BYE " + string);
    }

    private void untagged() {
        this.writer.print("*");
    }

    private void tag() {
        this.writer.print(this.tag);
    }

    private void commandName(ImapCommand imapCommand) {
        String string = imapCommand.getName();
        this.writer.print(" ");
        this.writer.print(string);
    }

    private void message(String string) {
        if (string != null) {
            this.writer.print(" ");
            this.writer.print(string);
        }
    }

    private void message(int n) {
        this.writer.print(" ");
        this.writer.print(n);
    }

    private void responseCode(String string) {
        if (string != null) {
            this.writer.print(" [");
            this.writer.print(string);
            this.writer.print("]");
        }
    }

    private void end() {
        this.writer.println();
        this.writer.flush();
    }

    public void permanentFlagsResponse(Flags flags) {
        this.untagged();
        this.message("OK");
        this.responseCode("PERMANENTFLAGS " + MessageFlags.format(flags));
        this.end();
    }
}

