/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class ImapSessionFolder
implements MailFolder,
FolderListener {
    private MailFolder _folder;
    private ImapSession _session;
    private boolean _readonly;
    private boolean _sizeChanged;
    private List _expungedMsns = Collections.synchronizedList(new LinkedList());
    private Map _modifiedFlags = Collections.synchronizedMap(new TreeMap());

    public ImapSessionFolder(MailFolder mailFolder, ImapSession imapSession, boolean bl) {
        this._folder = mailFolder;
        this._session = imapSession;
        this._readonly = bl;
        this._folder.addListener(this);
    }

    public void deselect() {
        this._folder.removeListener(this);
        this._folder = null;
    }

    public int getMsn(long l) throws FolderException {
        long[] lArray = this._folder.getMessageUids();
        for (int i = 0; i < lArray.length; ++i) {
            long l2 = lArray[i];
            if (l != l2) continue;
            return i + 1;
        }
        throw new FolderException("No such message.");
    }

    public void signalDeletion() {
        this._folder.signalDeletion();
    }

    public List getMessages(MsgRangeFilter msgRangeFilter) {
        return this._folder.getMessages(msgRangeFilter);
    }

    public List getMessages() {
        return this._folder.getMessages();
    }

    public List getNonDeletedMessages() {
        return this._folder.getNonDeletedMessages();
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getExpunged() throws FolderException {
        List list = this._expungedMsns;
        synchronized (list) {
            int[] nArray = new int[this._expungedMsns.size()];
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                nArray[i] = n = ((Integer)this._expungedMsns.get(i)).intValue();
            }
            this._expungedMsns.clear();
            if (!this._modifiedFlags.isEmpty() || this._sizeChanged) {
                throw new IllegalStateException("Need to do this properly...");
            }
            return nArray;
        }
    }

    public List getFlagUpdates() throws FolderException {
        if (this._modifiedFlags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._modifiedFlags.values());
        this._modifiedFlags.clear();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expunged(int n) {
        List list = this._expungedMsns;
        synchronized (list) {
            this._expungedMsns.add(new Integer(n));
        }
    }

    public void added(int n) {
        this._sizeChanged = true;
    }

    public void flagsUpdated(int n, Flags flags, Long l) {
        this._modifiedFlags.put(new Integer(n), new FlagUpdate(n, l, flags));
    }

    public void mailboxDeleted() {
        this._session.closeConnection("Mailbox " + this._folder.getName() + " has been deleted");
    }

    public String getName() {
        return this._folder.getName();
    }

    public String getFullName() {
        return this._folder.getFullName();
    }

    public Flags getPermanentFlags() {
        return this._folder.getPermanentFlags();
    }

    public int getMessageCount() {
        return this._folder.getMessageCount();
    }

    public int getRecentCount(boolean bl) {
        return this._folder.getRecentCount(bl);
    }

    public long getUidValidity() {
        return this._folder.getUidValidity();
    }

    public int getFirstUnseen() {
        return this.correctForExpungedMessages(this._folder.getFirstUnseen());
    }

    private int correctForExpungedMessages(int n) {
        int n2 = n;
        for (int i = this._expungedMsns.size() - 1; i >= 0; --i) {
            Integer n3 = (Integer)this._expungedMsns.get(i);
            if (n3 > n) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isSelectable() {
        return this._folder.isSelectable();
    }

    public long getUidNext() {
        return this._folder.getUidNext();
    }

    public int getUnseenCount() {
        return this._folder.getUnseenCount();
    }

    public long appendMessage(MimeMessage mimeMessage, Flags flags, Date date) {
        return this._folder.appendMessage(mimeMessage, flags, date);
    }

    public void store(MovingMessage movingMessage) throws Exception {
        this._folder.store(movingMessage);
    }

    public void store(MimeMessage mimeMessage) throws Exception {
        this._folder.store(mimeMessage);
    }

    public SimpleStoredMessage getMessage(long l) {
        return this._folder.getMessage(l);
    }

    public long[] getMessageUids() {
        return this._folder.getMessageUids();
    }

    public void expunge() throws FolderException {
        this._folder.expunge();
    }

    public long[] search(SearchTerm searchTerm) {
        return this._folder.search(searchTerm);
    }

    public void copyMessage(long l, MailFolder mailFolder) throws FolderException {
        this._folder.copyMessage(l, mailFolder);
    }

    public void addListener(FolderListener folderListener) {
        this._folder.addListener(folderListener);
    }

    public void removeListener(FolderListener folderListener) {
        this._folder.removeListener(folderListener);
    }

    public IdRange[] msnsToUids(IdRange[] idRangeArray) {
        return new IdRange[0];
    }

    public void setFlags(Flags flags, boolean bl, long l, FolderListener folderListener, boolean bl2) throws FolderException {
        this._folder.setFlags(flags, bl, l, folderListener, bl2);
    }

    public void replaceFlags(Flags flags, long l, FolderListener folderListener, boolean bl) throws FolderException {
        this._folder.replaceFlags(flags, l, folderListener, bl);
    }

    public void deleteAllMessages() {
        this._folder.deleteAllMessages();
    }

    public boolean isSizeChanged() {
        return this._sizeChanged;
    }

    public void setSizeChanged(boolean bl) {
        this._sizeChanged = bl;
    }

    static final class FlagUpdate {
        private int msn;
        private Long uid;
        private Flags flags;

        public FlagUpdate(int n, Long l, Flags flags) {
            this.msn = n;
            this.uid = l;
            this.flags = flags;
        }

        public int getMsn() {
            return this.msn;
        }

        public Long getUid() {
            return this.uid;
        }

        public Flags getFlags() {
            return this.flags;
        }
    }
}

