/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapHandler;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ImapSessionState;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserManager;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;

public final class ImapSessionImpl
implements ImapSession {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private GreenMailUser user = null;
    private ImapSessionFolder selectedMailbox = null;
    private String clientHostName;
    private String clientAddress;
    private ImapHandler handler;
    private ImapHostManager imapHost;
    private UserManager users;

    public ImapSessionImpl(ImapHostManager imapHostManager, UserManager userManager, ImapHandler imapHandler, String string, String string2) {
        this.imapHost = imapHostManager;
        this.users = userManager;
        this.handler = imapHandler;
        this.clientHostName = string;
        this.clientAddress = string2;
    }

    public ImapHostManager getHost() {
        return this.imapHost;
    }

    public void unsolicitedResponses(ImapResponse imapResponse) throws FolderException {
        this.unsolicitedResponses(imapResponse, false);
    }

    public void unsolicitedResponses(ImapResponse imapResponse, boolean bl) throws FolderException {
        ImapSessionFolder imapSessionFolder = this.getSelected();
        if (imapSessionFolder != null) {
            int n;
            Object object;
            if (imapSessionFolder.isSizeChanged()) {
                imapResponse.existsResponse(imapSessionFolder.getMessageCount());
                imapResponse.recentResponse(imapSessionFolder.getRecentCount(true));
                imapSessionFolder.setSizeChanged(false);
            }
            List list = imapSessionFolder.getFlagUpdates();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (ImapSessionFolder.FlagUpdate)iterator.next();
                n = ((ImapSessionFolder.FlagUpdate)object).getMsn();
                Flags flags = ((ImapSessionFolder.FlagUpdate)object).getFlags();
                StringBuffer stringBuffer = new StringBuffer("FLAGS ");
                stringBuffer.append(MessageFlags.format(flags));
                if (((ImapSessionFolder.FlagUpdate)object).getUid() != null) {
                    stringBuffer.append(" UID ");
                    stringBuffer.append(((ImapSessionFolder.FlagUpdate)object).getUid());
                }
                imapResponse.fetchResponse(n, stringBuffer.toString());
            }
            if (!bl) {
                object = imapSessionFolder.getExpunged();
                for (n = 0; n < ((Object)object).length; ++n) {
                    Object object2 = object[n];
                    imapResponse.expungeResponse((int)object2);
                }
            }
        }
    }

    public void closeConnection(String string) {
        this.handler.forceConnectionClose(string);
    }

    public void closeConnection() {
        this.handler.resetHandler();
    }

    public UserManager getUserManager() {
        return this.users;
    }

    public String getClientHostname() {
        return this.clientHostName;
    }

    public String getClientIP() {
        return this.clientAddress;
    }

    public void setAuthenticated(GreenMailUser greenMailUser) {
        this.state = ImapSessionState.AUTHENTICATED;
        this.user = greenMailUser;
    }

    public GreenMailUser getUser() {
        return this.user;
    }

    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        if (this.selectedMailbox != null) {
            this.selectedMailbox.removeListener(this.selectedMailbox);
            this.selectedMailbox = null;
        }
    }

    public void setSelected(MailFolder mailFolder, boolean bl) {
        ImapSessionFolder imapSessionFolder = new ImapSessionFolder(mailFolder, this, bl);
        this.state = ImapSessionState.SELECTED;
        this.selectedMailbox = imapSessionFolder;
    }

    public ImapSessionFolder getSelected() {
        return this.selectedMailbox;
    }

    public boolean selectedIsReadOnly() {
        return this.selectedMailbox.isReadonly();
    }

    public ImapSessionState getState() {
        return this.state;
    }
}

