/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;

class AppendCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "APPEND";
    public static final String ARGS = "<mailbox> [<flag_list>] [<date_time>] literal";
    private AppendCommandParser parser = new AppendCommandParser();

    AppendCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        Date date;
        String string = this.parser.mailbox(imapRequestLineReader);
        Flags flags = this.parser.optionalAppendFlags(imapRequestLineReader);
        if (flags == null) {
            flags = new Flags();
        }
        if ((date = this.parser.optionalDateTime(imapRequestLineReader)) == null) {
            date = new Date();
        }
        MimeMessage mimeMessage = this.parser.mimeMessage(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        MailFolder mailFolder = null;
        try {
            mailFolder = this.getMailbox(string, imapSession, true);
        }
        catch (FolderException folderException) {
            folderException.setResponseCode("TRYCREATE");
            throw folderException;
        }
        mailFolder.appendMessage(mimeMessage, flags, date);
        imapSession.unsolicitedResponses(imapResponse);
        imapResponse.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    class FixedLengthInputStream
    extends FilterInputStream {
        private long pos;
        private long length;

        public FixedLengthInputStream(InputStream inputStream, long l) {
            super(inputStream);
            this.pos = 0L;
            this.length = l;
        }

        public int read() throws IOException {
            if (this.pos >= this.length) {
                return -1;
            }
            ++this.pos;
            return super.read();
        }

        public int read(byte[] byArray) throws IOException {
            if (this.pos >= this.length) {
                return -1;
            }
            if (this.pos + (long)byArray.length >= this.length) {
                this.pos = this.length;
                return super.read(byArray, 0, (int)(this.length - this.pos));
            }
            this.pos += (long)byArray.length;
            return super.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("Not implemented");
        }

        public long skip(long l) throws IOException {
            throw new IOException("Not implemented");
        }

        public int available() throws IOException {
            return super.available();
        }

        public void close() throws IOException {
        }

        public synchronized void mark(int n) {
        }

        public synchronized void reset() throws IOException {
            throw new IOException("mark not supported");
        }

        public boolean markSupported() {
            return false;
        }
    }

    private class AppendCommandParser
    extends CommandParser {
        private AppendCommandParser() {
        }

        public Flags optionalAppendFlags(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextWordChar();
            if (c == '(') {
                return this.flagList(imapRequestLineReader);
            }
            return null;
        }

        public Date optionalDateTime(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextWordChar();
            if (c == '\"') {
                return this.dateTime(imapRequestLineReader);
            }
            return null;
        }

        public MimeMessage mimeMessage(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            imapRequestLineReader.nextWordChar();
            String string = this.consumeLiteral(imapRequestLineReader);
            try {
                return GreenMailUtil.newMimeMessage(string);
            }
            catch (Exception exception) {
                throw new ProtocolException("UnexpectedException: " + exception.getMessage());
            }
        }
    }
}

