/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.Flags;

public class CommandParser {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    public String atom(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        return this.consumeWord(imapRequestLineReader, new ATOM_CHARValidator());
    }

    public String tag(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        TagCharValidator tagCharValidator = new TagCharValidator();
        return this.consumeWord(imapRequestLineReader, tagCharValidator);
    }

    public String astring(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        char c = imapRequestLineReader.nextWordChar();
        switch (c) {
            case '\"': {
                return this.consumeQuoted(imapRequestLineReader);
            }
            case '{': {
                return this.consumeLiteral(imapRequestLineReader);
            }
        }
        return this.atom(imapRequestLineReader);
    }

    public String nstring(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        char c = imapRequestLineReader.nextWordChar();
        switch (c) {
            case '\"': {
                return this.consumeQuoted(imapRequestLineReader);
            }
            case '{': {
                return this.consumeLiteral(imapRequestLineReader);
            }
        }
        String string = this.atom(imapRequestLineReader);
        if ("NIL".equals(string)) {
            return null;
        }
        throw new ProtocolException("Invalid nstring value: valid values are '\"...\"', '{12} CRLF *CHAR8', and 'NIL'.");
    }

    public String mailbox(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        String string = this.astring(imapRequestLineReader);
        if (string.equalsIgnoreCase("INBOX")) {
            return "INBOX";
        }
        return string;
    }

    public Date dateTime(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        char c = imapRequestLineReader.nextWordChar();
        if (c != '\"') {
            throw new ProtocolException("DateTime values must be quoted.");
        }
        String string = this.consumeQuoted(imapRequestLineReader);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss zzzz");
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new ProtocolException("Invalid date format.");
        }
    }

    public Date date(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        char c = imapRequestLineReader.nextWordChar();
        String string = c == '\"' ? this.consumeQuoted(imapRequestLineReader) : this.atom(imapRequestLineReader);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new ProtocolException("Invalid date format.");
        }
    }

    protected String consumeWord(ImapRequestLineReader imapRequestLineReader, CharacterValidator characterValidator) throws ProtocolException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = imapRequestLineReader.nextWordChar();
        while (!this.isWhitespace(c)) {
            if (!characterValidator.isValid(c)) {
                throw new ProtocolException("Invalid character: '" + c + "'");
            }
            stringBuffer.append(c);
            imapRequestLineReader.consume();
            c = imapRequestLineReader.nextChar();
        }
        return stringBuffer.toString();
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    protected String consumeLiteral(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        this.consumeChar(imapRequestLineReader, '{');
        StringBuffer stringBuffer = new StringBuffer();
        char c = imapRequestLineReader.nextChar();
        while (c != '}' && c != '+') {
            stringBuffer.append(c);
            imapRequestLineReader.consume();
            c = imapRequestLineReader.nextChar();
        }
        boolean bl = true;
        if (c == '+') {
            bl = false;
            this.consumeChar(imapRequestLineReader, '+');
        }
        this.consumeChar(imapRequestLineReader, '}');
        this.consumeCRLF(imapRequestLineReader);
        if (bl) {
            imapRequestLineReader.commandContinuationRequest();
        }
        int n = Integer.parseInt(stringBuffer.toString());
        byte[] byArray = new byte[n];
        imapRequestLineReader.read(byArray);
        return new String(byArray);
    }

    private void consumeCRLF(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        char c = imapRequestLineReader.nextChar();
        if (c != '\n') {
            this.consumeChar(imapRequestLineReader, '\r');
        }
        this.consumeChar(imapRequestLineReader, '\n');
    }

    protected void consumeChar(ImapRequestLineReader imapRequestLineReader, char c) throws ProtocolException {
        char c2 = imapRequestLineReader.consume();
        if (c2 != c) {
            throw new ProtocolException("Expected:'" + c + "' found:'" + c2 + "'");
        }
    }

    protected String consumeQuoted(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        this.consumeChar(imapRequestLineReader, '\"');
        StringBuffer stringBuffer = new StringBuffer();
        char c = imapRequestLineReader.nextChar();
        while (c != '\"') {
            if (c == '\\') {
                imapRequestLineReader.consume();
                c = imapRequestLineReader.nextChar();
                if (!this.isQuotedSpecial(c)) {
                    throw new ProtocolException("Invalid escaped character in quote: '" + c + "'");
                }
            }
            stringBuffer.append(c);
            imapRequestLineReader.consume();
            c = imapRequestLineReader.nextChar();
        }
        this.consumeChar(imapRequestLineReader, '\"');
        return stringBuffer.toString();
    }

    public byte[] base64(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        return null;
    }

    public Flags flagList(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        Flags flags = new Flags();
        imapRequestLineReader.nextWordChar();
        this.consumeChar(imapRequestLineReader, '(');
        NoopCharValidator noopCharValidator = new NoopCharValidator();
        String string = this.consumeWord(imapRequestLineReader, noopCharValidator);
        while (!string.endsWith(")")) {
            this.setFlag(string, flags);
            string = this.consumeWord(imapRequestLineReader, noopCharValidator);
        }
        if (string.length() > 1) {
            this.setFlag(string.substring(0, string.length() - 1), flags);
        }
        return flags;
    }

    public void setFlag(String string, Flags flags) throws ProtocolException {
        if (string.equalsIgnoreCase("\\ANSWERED")) {
            flags.add(Flags.Flag.ANSWERED);
        } else if (string.equalsIgnoreCase("\\DELETED")) {
            flags.add(Flags.Flag.DELETED);
        } else if (string.equalsIgnoreCase("\\DRAFT")) {
            flags.add(Flags.Flag.DRAFT);
        } else if (string.equalsIgnoreCase("\\FLAGGED")) {
            flags.add(Flags.Flag.FLAGGED);
        } else if (string.equalsIgnoreCase("\\SEEN")) {
            flags.add(Flags.Flag.SEEN);
        } else {
            throw new ProtocolException("Invalid flag string.");
        }
    }

    public long number(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        String string = this.consumeWord(imapRequestLineReader, new DigitCharValidator());
        return Long.parseLong(string);
    }

    public long nzNumber(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        long l = this.number(imapRequestLineReader);
        if (l == 0L) {
            throw new ProtocolException("Zero value not permitted.");
        }
        return l;
    }

    private boolean isCHAR(char c) {
        return c >= '\u0001' && c <= '\u007f';
    }

    private boolean isCHAR8(char c) {
        return c >= '\u0001' && c <= '\u00ff';
    }

    protected boolean isListWildcard(char c) {
        return c == '*' || c == '%';
    }

    private boolean isQuotedSpecial(char c) {
        return c == '\"' || c == '\\';
    }

    public void endLine(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        imapRequestLineReader.eol();
    }

    public IdRange[] parseIdRange(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
        String string;
        MessageSetCharValidator messageSetCharValidator = new MessageSetCharValidator();
        String string2 = this.consumeWord(imapRequestLineReader, messageSetCharValidator);
        int n = string2.indexOf(44);
        if (n == -1) {
            return new IdRange[]{this.parseRange(string2)};
        }
        ArrayList<IdRange> arrayList = new ArrayList<IdRange>();
        int n2 = 0;
        while (n != -1) {
            string = string2.substring(n2, n);
            IdRange idRange = this.parseRange(string);
            arrayList.add(idRange);
            n2 = n + 1;
            n = string2.indexOf(44, n2);
        }
        string = string2.substring(n2);
        arrayList.add(this.parseRange(string));
        return arrayList.toArray(new IdRange[arrayList.size()]);
    }

    private IdRange parseRange(String string) throws ProtocolException {
        int n = string.indexOf(58);
        try {
            if (n == -1) {
                long l = this.parseLong(string);
                return new IdRange(l);
            }
            long l = this.parseLong(string.substring(0, n));
            long l2 = this.parseLong(string.substring(n + 1));
            return new IdRange(l, l2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Invalid message set.");
        }
    }

    private long parseLong(String string) {
        if (string.length() == 1 && string.charAt(0) == '*') {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(string);
    }

    private class MessageSetCharValidator
    implements CharacterValidator {
        private MessageSetCharValidator() {
        }

        public boolean isValid(char c) {
            return this.isDigit(c) || c == ':' || c == '*' || c == ',';
        }

        private boolean isDigit(char c) {
            return '0' <= c && c <= '9';
        }
    }

    private class TagCharValidator
    extends ATOM_CHARValidator {
        private TagCharValidator() {
        }

        public boolean isValid(char c) {
            if (c == '+') {
                return false;
            }
            return super.isValid(c);
        }
    }

    protected class DigitCharValidator
    implements CharacterValidator {
        protected DigitCharValidator() {
        }

        public boolean isValid(char c) {
            return c >= '0' && c <= '9' || c == '*';
        }
    }

    protected class ATOM_CHARValidator
    implements CharacterValidator {
        protected ATOM_CHARValidator() {
        }

        public boolean isValid(char c) {
            return CommandParser.this.isCHAR(c) && !this.isAtomSpecial(c) && !CommandParser.this.isListWildcard(c) && !CommandParser.this.isQuotedSpecial(c);
        }

        private boolean isAtomSpecial(char c) {
            return c == '(' || c == ')' || c == '{' || c == ' ' || c == '\u000f';
        }
    }

    protected class NoopCharValidator
    implements CharacterValidator {
        protected NoopCharValidator() {
        }

        public boolean isValid(char c) {
            return true;
        }
    }

    protected static interface CharacterValidator {
        public boolean isValid(char var1);
    }
}

