/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionState;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

abstract class CommandTemplate
implements ImapCommand,
ImapConstants {
    protected CommandParser parser = new CommandParser();

    CommandTemplate() {
    }

    public boolean validForState(ImapSessionState imapSessionState) {
        return true;
    }

    public void process(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) {
        try {
            this.doProcess(imapRequestLineReader, imapResponse, imapSession);
        }
        catch (FolderException folderException) {
            imapResponse.commandFailed(this, folderException.getResponseCode(), folderException.getMessage());
        }
        catch (AuthorizationException authorizationException) {
            String string = "Authorization error: Lacking permissions to perform requested operation.";
            imapResponse.commandFailed(this, string);
        }
        catch (ProtocolException protocolException) {
            String string = protocolException.getMessage() + " Command should be '" + this.getExpectedMessage() + "'";
            imapResponse.commandError(string);
        }
    }

    protected abstract void doProcess(ImapRequestLineReader var1, ImapResponse var2, ImapSession var3) throws ProtocolException, FolderException, AuthorizationException;

    protected String getExpectedMessage() {
        StringBuffer stringBuffer = new StringBuffer("<tag> ");
        stringBuffer.append(this.getName());
        String string = this.getArgSyntax();
        if (string != null && string.length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected abstract String getArgSyntax();

    protected MailFolder getMailbox(String string, ImapSession imapSession, boolean bl) throws FolderException {
        return imapSession.getHost().getFolder(imapSession.getUser(), string, bl);
    }

    protected MailFolder getMailbox(String string, ImapSession imapSession) {
        try {
            return imapSession.getHost().getFolder(imapSession.getUser(), string, false);
        }
        catch (FolderException folderException) {
            throw new RuntimeException("Unexpected error in CommandTemplate.java");
        }
    }

    public CommandParser getParser() {
        return this.parser;
    }
}

