/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class CopyCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "COPY";
    public static final String ARGS = "<message-set> <mailbox>";

    CopyCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        this.doProcess(imapRequestLineReader, imapResponse, imapSession, false);
    }

    public void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession, boolean bl) throws ProtocolException, FolderException {
        MailFolder mailFolder;
        IdRange[] idRangeArray = this.parser.parseIdRange(imapRequestLineReader);
        String string = this.parser.mailbox(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        ImapSessionFolder imapSessionFolder = imapSession.getSelected();
        try {
            mailFolder = this.getMailbox(string, imapSession, true);
        }
        catch (FolderException folderException) {
            folderException.setResponseCode("TRYCREATE");
            throw folderException;
        }
        long[] lArray = imapSessionFolder.getMessageUids();
        for (int i = 0; i < lArray.length; ++i) {
            boolean bl2;
            long l = lArray[i];
            if (bl) {
                bl2 = this.includes(idRangeArray, l);
            } else {
                int n = imapSessionFolder.getMsn(l);
                bl2 = this.includes(idRangeArray, n);
            }
            if (!bl2) continue;
            imapSessionFolder.copyMessage(l, mailFolder);
        }
        imapSession.unsolicitedResponses(imapResponse);
        imapResponse.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

