/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.mail.Flags;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

class FetchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "FETCH";
    public static final String ARGS = "<message-set> <fetch-profile>";
    private FetchCommandParser parser = new FetchCommandParser();

    FetchCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        this.doProcess(imapRequestLineReader, imapResponse, imapSession, false);
    }

    public void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession, boolean bl) throws ProtocolException, FolderException {
        int n;
        IdRange[] idRangeArray = this.parser.parseIdRange(imapRequestLineReader);
        FetchRequest fetchRequest = this.parser.fetchRequest(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        if (bl) {
            fetchRequest.uid = true;
        }
        ImapSessionFolder imapSessionFolder = imapSession.getSelected();
        long[] lArray = imapSessionFolder.getMessageUids();
        for (n = 0; n < lArray.length; ++n) {
            long l = lArray[n];
            int n2 = imapSessionFolder.getMsn(l);
            if ((!bl || !this.includes(idRangeArray, l)) && (bl || !this.includes(idRangeArray, n2))) continue;
            SimpleStoredMessage simpleStoredMessage = imapSessionFolder.getMessage(l);
            String string = this.outputMessage(fetchRequest, simpleStoredMessage, imapSessionFolder, bl);
            imapResponse.fetchResponse(n2, string);
        }
        n = !bl ? 1 : 0;
        imapSession.unsolicitedResponses(imapResponse, n != 0);
        imapResponse.commandComplete(this);
    }

    private String outputMessage(FetchRequest fetchRequest, SimpleStoredMessage simpleStoredMessage, ImapSessionFolder imapSessionFolder, boolean bl) throws FolderException, ProtocolException {
        boolean bl2 = false;
        if (fetchRequest.isSetSeen() && !simpleStoredMessage.getFlags().contains(Flags.Flag.SEEN)) {
            imapSessionFolder.setFlags(new Flags(Flags.Flag.SEEN), true, simpleStoredMessage.getUid(), imapSessionFolder, bl);
            simpleStoredMessage.getFlags().add(Flags.Flag.SEEN);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (fetchRequest.flags || bl2) {
            stringBuffer.append(" FLAGS ");
            stringBuffer.append(MessageFlags.format(simpleStoredMessage.getFlags()));
        }
        if (fetchRequest.internalDate) {
            stringBuffer.append(" INTERNALDATE \"");
            stringBuffer.append(simpleStoredMessage.getAttributes().getInternalDateAsString());
            stringBuffer.append("\"");
        }
        if (fetchRequest.size) {
            stringBuffer.append(" RFC822.SIZE ");
            stringBuffer.append(simpleStoredMessage.getAttributes().getSize());
        }
        if (fetchRequest.envelope) {
            stringBuffer.append(" ENVELOPE ");
            stringBuffer.append(simpleStoredMessage.getAttributes().getEnvelope());
        }
        if (fetchRequest.body) {
            stringBuffer.append(" BODY ");
            stringBuffer.append(simpleStoredMessage.getAttributes().getBodyStructure(false));
        }
        if (fetchRequest.bodyStructure) {
            stringBuffer.append(" BODYSTRUCTURE ");
            stringBuffer.append(simpleStoredMessage.getAttributes().getBodyStructure(true));
        }
        if (fetchRequest.uid) {
            stringBuffer.append(" UID ");
            stringBuffer.append(simpleStoredMessage.getUid());
        }
        Collection collection = fetchRequest.getBodyElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BodyFetchElement bodyFetchElement = (BodyFetchElement)iterator.next();
            stringBuffer.append(" ");
            stringBuffer.append(bodyFetchElement.getResponseName());
            if (null == bodyFetchElement.getPartial()) {
                stringBuffer.append(" ");
            }
            String string = bodyFetchElement.getParameters();
            MimeMessage mimeMessage = simpleStoredMessage.getMimeMessage();
            try {
                this.handleBodyFetch(mimeMessage, string, bodyFetchElement.getPartial(), stringBuffer);
            }
            catch (Exception exception) {
                throw new FolderException(exception.getMessage());
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return "";
    }

    private void handleBodyFetch(MimeMessage mimeMessage, String string, String string2, StringBuffer stringBuffer) throws Exception {
        if (string.length() == 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray = this.doPartial(string2, byArray, stringBuffer);
            this.addLiteral(byArray, stringBuffer);
        } else if (string.equalsIgnoreCase("HEADER")) {
            Enumeration enumeration = mimeMessage.getAllHeaderLines();
            this.addHeaders(enumeration, stringBuffer);
        } else if (string.startsWith("HEADER.FIELDS.NOT")) {
            String[] stringArray = this.extractHeaderList(string, "HEADER.FIELDS.NOT".length());
            Enumeration enumeration = mimeMessage.getNonMatchingHeaderLines(stringArray);
            this.addHeaders(enumeration, stringBuffer);
        } else if (string.startsWith("HEADER.FIELDS ")) {
            String[] stringArray = this.extractHeaderList(string, "HEADER.FIELDS ".length());
            Enumeration enumeration = mimeMessage.getMatchingHeaderLines(stringArray);
            this.addHeaders(enumeration, stringBuffer);
        } else if (string.endsWith("MIME")) {
            String[] stringArray = string.trim().split("\\.");
            int n = Integer.parseInt(stringArray[0]) - 1;
            MimeMultipart mimeMultipart = (MimeMultipart)mimeMessage.getContent();
            byte[] byArray = GreenMailUtil.getHeaderAsBytes((Part)mimeMultipart.getBodyPart(n));
            byArray = this.doPartial(string2, byArray, stringBuffer);
            this.addLiteral(byArray, stringBuffer);
        } else if (string.equalsIgnoreCase("TEXT")) {
            byte[] byArray = GreenMailUtil.getBodyAsBytes((Part)mimeMessage);
            byArray = this.doPartial(string2, byArray, stringBuffer);
            this.addLiteral(byArray, stringBuffer);
        } else {
            int n = Integer.parseInt(string) - 1;
            MimeMultipart mimeMultipart = (MimeMultipart)mimeMessage.getContent();
            byte[] byArray = GreenMailUtil.getBodyAsBytes((Part)mimeMultipart.getBodyPart(n));
            byArray = this.doPartial(string2, byArray, stringBuffer);
            this.addLiteral(byArray, stringBuffer);
        }
    }

    private byte[] doPartial(String string, byte[] byArray, StringBuffer stringBuffer) {
        if (null != string) {
            String[] stringArray = string.split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = 2 == stringArray.length ? Integer.parseInt(stringArray[1]) : byArray.length;
            n = Math.min(n, byArray.length);
            n2 = Math.min(n2, byArray.length);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            byArray = byArray2;
            stringBuffer.append("<");
            stringBuffer.append(n);
            stringBuffer.append("> ");
        }
        return byArray;
    }

    private void addLiteral(byte[] byArray, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        stringBuffer.append(byArray.length);
        stringBuffer.append('}');
        stringBuffer.append("\r\n");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append((char)by);
        }
    }

    private String[] extractHeaderList(String string, int n) {
        String string2 = string.substring(n + 1, string.length() - 1);
        String[] stringArray = this.split(string2, " ");
        return stringArray;
    }

    private String[] split(String string, String string2) {
        String string3;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            string3 = string.substring(n2, n);
            arrayList.add(string3);
            n2 = n + 1;
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList.toArray(new String[0]);
    }

    private void addHeaders(Enumeration enumeration, StringBuffer stringBuffer) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            n += ((String)object).length() + 2;
            arrayList.add((String)object);
        }
        stringBuffer.append('{');
        stringBuffer.append(n + 2);
        stringBuffer.append('}');
        stringBuffer.append("\r\n");
        object = arrayList.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("\r\n");
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class BodyFetchElement {
        private String name;
        private String sectionIdentifier;
        private String partial;

        public BodyFetchElement(String string, String string2) {
            this(string, string2, null);
        }

        public BodyFetchElement(String string, String string2, String string3) {
            this.name = string;
            this.sectionIdentifier = string2;
            this.partial = string3;
        }

        public String getParameters() {
            return this.sectionIdentifier;
        }

        public String getResponseName() {
            return this.name;
        }

        public String getPartial() {
            return this.partial;
        }
    }

    private static class FetchRequest {
        boolean flags;
        boolean uid;
        boolean internalDate;
        boolean size;
        boolean envelope;
        boolean body;
        boolean bodyStructure;
        private boolean setSeen = false;
        private Set bodyElements = new HashSet();

        private FetchRequest() {
        }

        public Collection getBodyElements() {
            return this.bodyElements;
        }

        public boolean isSetSeen() {
            return this.setSeen;
        }

        public void add(BodyFetchElement bodyFetchElement, boolean bl) {
            if (!bl) {
                this.setSeen = true;
            }
            this.bodyElements.add(bodyFetchElement);
        }
    }

    private class FetchCommandParser
    extends CommandParser {
        private FetchCommandParser() {
        }

        public FetchRequest fetchRequest(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            FetchRequest fetchRequest = new FetchRequest();
            char c = this.nextNonSpaceChar(imapRequestLineReader);
            this.consumeChar(imapRequestLineReader, '(');
            c = this.nextNonSpaceChar(imapRequestLineReader);
            while (c != ')') {
                this.addNextElement(imapRequestLineReader, fetchRequest);
                c = this.nextNonSpaceChar(imapRequestLineReader);
            }
            this.consumeChar(imapRequestLineReader, ')');
            return fetchRequest;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNextElement(ImapRequestLineReader imapRequestLineReader, FetchRequest fetchRequest) throws ProtocolException {
            char c = this.nextCharInLine(imapRequestLineReader);
            StringBuffer stringBuffer = new StringBuffer();
            while (c != ' ' && c != '[' && c != ')') {
                stringBuffer.append(c);
                imapRequestLineReader.consume();
                c = this.nextCharInLine(imapRequestLineReader);
            }
            String string = stringBuffer.toString();
            if (c == ' ' || c == ')') {
                if ("FAST".equalsIgnoreCase(string)) {
                    fetchRequest.flags = true;
                    fetchRequest.internalDate = true;
                    fetchRequest.size = true;
                    return;
                } else if ("FULL".equalsIgnoreCase(string)) {
                    fetchRequest.flags = true;
                    fetchRequest.internalDate = true;
                    fetchRequest.size = true;
                    fetchRequest.envelope = true;
                    fetchRequest.body = true;
                    return;
                } else if ("ALL".equalsIgnoreCase(string)) {
                    fetchRequest.flags = true;
                    fetchRequest.internalDate = true;
                    fetchRequest.size = true;
                    fetchRequest.envelope = true;
                    return;
                } else if ("FLAGS".equalsIgnoreCase(string)) {
                    fetchRequest.flags = true;
                    return;
                } else if ("RFC822.SIZE".equalsIgnoreCase(string)) {
                    fetchRequest.size = true;
                    return;
                } else if ("ENVELOPE".equalsIgnoreCase(string)) {
                    fetchRequest.envelope = true;
                    return;
                } else if ("INTERNALDATE".equalsIgnoreCase(string)) {
                    fetchRequest.internalDate = true;
                    return;
                } else if ("BODY".equalsIgnoreCase(string)) {
                    fetchRequest.body = true;
                    return;
                } else if ("BODYSTRUCTURE".equalsIgnoreCase(string)) {
                    fetchRequest.bodyStructure = true;
                    return;
                } else if ("UID".equalsIgnoreCase(string)) {
                    fetchRequest.uid = true;
                    return;
                } else if ("RFC822".equalsIgnoreCase(string)) {
                    fetchRequest.add(new BodyFetchElement("RFC822", ""), false);
                    return;
                } else if ("RFC822.HEADER".equalsIgnoreCase(string)) {
                    fetchRequest.add(new BodyFetchElement("RFC822.HEADER", "HEADER"), true);
                    return;
                } else {
                    if (!"RFC822.TEXT".equalsIgnoreCase(string)) throw new ProtocolException("Invalid fetch attribute: " + string);
                    fetchRequest.add(new BodyFetchElement("RFC822.TEXT", "TEXT"), false);
                }
                return;
            } else {
                this.consumeChar(imapRequestLineReader, '[');
                StringBuffer stringBuffer2 = new StringBuffer();
                c = this.nextCharInLine(imapRequestLineReader);
                while (c != ']') {
                    stringBuffer2.append(c);
                    imapRequestLineReader.consume();
                    c = this.nextCharInLine(imapRequestLineReader);
                }
                this.consumeChar(imapRequestLineReader, ']');
                String string2 = stringBuffer2.toString();
                String string3 = null;
                c = this.nextCharInLine(imapRequestLineReader);
                if ('<' == c) {
                    string3 = "";
                    this.consumeChar(imapRequestLineReader, '<');
                    c = this.nextCharInLine(imapRequestLineReader);
                    while (c != '>') {
                        string3 = string3 + c;
                        imapRequestLineReader.consume();
                        c = this.nextCharInLine(imapRequestLineReader);
                    }
                    this.consumeChar(imapRequestLineReader, '>');
                    c = this.nextCharInLine(imapRequestLineReader);
                }
                if ("BODY".equalsIgnoreCase(string)) {
                    fetchRequest.add(new BodyFetchElement("BODY[" + string2 + "]", string2, string3), false);
                    return;
                } else {
                    if (!"BODY.PEEK".equalsIgnoreCase(string)) throw new ProtocolException("Invalid fetch attibute: " + string + "[]");
                    fetchRequest.add(new BodyFetchElement("BODY[" + string2 + "]", string2, string3), true);
                }
            }
        }

        private char nextCharInLine(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextChar();
            if (c == '\r' || c == '\n') {
                throw new ProtocolException("Unexpected end of line.");
            }
            return c;
        }

        private char nextNonSpaceChar(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextChar();
            while (c == ' ') {
                imapRequestLineReader.consume();
                c = imapRequestLineReader.nextChar();
            }
            return c;
        }
    }
}

