/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ListCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "LIST";
    public static final String ARGS = "<reference-name> <mailbox-name-with-wildcards>";
    private ListCommandParser parser = new ListCommandParser();

    ListCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        ArrayList<MailFolder> arrayList;
        String string;
        boolean bl;
        String string2 = this.parser.mailbox(imapRequestLineReader);
        String string3 = this.parser.listMailbox(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        if (string3.length() == 0) {
            if (string2.startsWith(NAMESPACE_PREFIX)) {
                bl = false;
                int n = string2.indexOf(46);
                string = n == -1 ? string2 : string2.substring(0, n);
            } else {
                string = "";
                bl = true;
            }
            MailFolder mailFolder = this.getMailbox(string, imapSession, false);
            if (mailFolder == null) {
                mailFolder = this.getMailbox("", imapSession, true);
                bl = true;
            }
            arrayList = new ArrayList<MailFolder>(1);
            arrayList.add(mailFolder);
        } else {
            string = string3.charAt(0) == '#' ? string3 : this.combineSearchTerms(string2, string3);
            bl = string.charAt(0) != '#';
            arrayList = this.doList(imapSession, string);
        }
        string = "#mail." + imapSession.getUser().getQualifiedMailboxName();
        int n = string.length();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MailFolder mailFolder = (MailFolder)iterator.next();
            StringBuffer stringBuffer = new StringBuffer("(");
            if (!mailFolder.isSelectable()) {
                stringBuffer.append("\\Noselect");
            }
            stringBuffer.append(") \"");
            stringBuffer.append('.');
            stringBuffer.append("\" ");
            String string4 = mailFolder.getFullName();
            if (bl) {
                string4 = string4.length() <= n ? "" : string4.substring(n + 1);
            }
            if (string4.length() == 0) {
                stringBuffer.append("\"\"");
            } else {
                stringBuffer.append(string4);
            }
            imapResponse.commandResponse(this, stringBuffer.toString());
        }
        imapSession.unsolicitedResponses(imapResponse);
        imapResponse.commandComplete(this);
    }

    protected Collection doList(ImapSession imapSession, String string) throws FolderException {
        return imapSession.getHost().listMailboxes(imapSession.getUser(), string);
    }

    private String combineSearchTerms(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (string.endsWith(HIERARCHY_DELIMITER)) {
            if (stringBuffer.charAt(0) == '.') {
                stringBuffer.deleteCharAt(0);
            }
        } else if (stringBuffer.charAt(0) != '.' && string.length() != 0) {
            stringBuffer.insert(0, '.');
        }
        stringBuffer.insert(0, string);
        return stringBuffer.toString();
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class ListCommandParser
    extends CommandParser {
        private final char[] WILDCARD_CHARS = new char[]{'*', '%'};

        private ListCommandParser() {
        }

        public String listMailbox(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextWordChar();
            switch (c) {
                case '\"': {
                    return this.consumeQuoted(imapRequestLineReader);
                }
                case '{': {
                    return this.consumeLiteral(imapRequestLineReader);
                }
            }
            return this.consumeWord(imapRequestLineReader, new ListCharValidator());
        }

        private class ListCharValidator
        extends CommandParser.ATOM_CHARValidator {
            private ListCharValidator() {
            }

            public boolean isValid(char c) {
                if (ListCommandParser.this.isListWildcard(c)) {
                    return true;
                }
                return super.isValid(c);
            }
        }
    }
}

