/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

class SearchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "SEARCH";
    public static final String ARGS = "<search term>";
    private SearchCommandParser parser = new SearchCommandParser();

    SearchCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        this.doProcess(imapRequestLineReader, imapResponse, imapSession, false);
    }

    public void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession, boolean bl) throws ProtocolException, FolderException {
        int n;
        SearchTerm searchTerm = this.parser.searchTerm(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        ImapSessionFolder imapSessionFolder = imapSession.getSelected();
        long[] lArray = imapSessionFolder.search(searchTerm);
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < lArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            long l = lArray[n];
            if (bl) {
                stringBuffer.append(l);
                continue;
            }
            int n2 = imapSessionFolder.getMsn(l);
            stringBuffer.append(n2);
        }
        imapResponse.commandResponse(this, stringBuffer.toString());
        n = !bl ? 1 : 0;
        imapSession.unsolicitedResponses(imapResponse, n != 0);
        imapResponse.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class SearchCommandParser
    extends CommandParser {
        private SearchCommandParser() {
        }

        public SearchTerm searchTerm(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            char c = imapRequestLineReader.nextChar();
            while (c != '\n') {
                imapRequestLineReader.consume();
                c = imapRequestLineReader.nextChar();
            }
            return new SearchTerm(){

                public boolean match(Message message) {
                    return true;
                }
            };
        }
    }
}

