/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.ExamineCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class SelectCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "SELECT";
    public static final String ARGS = "mailbox";

    SelectCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        String string = this.parser.mailbox(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        imapSession.deselect();
        boolean bl = this instanceof ExamineCommand;
        this.selectMailbox(string, imapSession, bl);
        ImapSessionFolder imapSessionFolder = imapSession.getSelected();
        imapResponse.flagsResponse(imapSessionFolder.getPermanentFlags());
        imapResponse.existsResponse(imapSessionFolder.getMessageCount());
        boolean bl2 = !bl;
        imapResponse.recentResponse(imapSessionFolder.getRecentCount(bl2));
        imapResponse.okResponse("UIDVALIDITY " + imapSessionFolder.getUidValidity(), null);
        int n = imapSessionFolder.getFirstUnseen();
        if (n > 0) {
            imapResponse.okResponse("UNSEEN " + n, "Message " + n + " is the first unseen");
        } else {
            imapResponse.okResponse(null, "No messages unseen");
        }
        imapResponse.permanentFlagsResponse(imapSessionFolder.getPermanentFlags());
        if (imapSessionFolder.isReadonly()) {
            imapResponse.commandComplete(this, "READ-ONLY");
        } else {
            imapResponse.commandComplete(this, "READ-WRITE");
        }
    }

    private boolean selectMailbox(String string, ImapSession imapSession, boolean bl) throws FolderException {
        MailFolder mailFolder = this.getMailbox(string, imapSession, true);
        if (!mailFolder.isSelectable()) {
            throw new FolderException("Nonselectable mailbox.");
        }
        imapSession.setSelected(mailFolder, bl);
        return bl;
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }
}

