/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class StatusCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "STATUS";
    public static final String ARGS = "<mailbox> ( <status-data-item>+ )";
    private static final String MESSAGES = "MESSAGES";
    private static final String RECENT = "RECENT";
    private static final String UIDNEXT = "UIDNEXT";
    private static final String UIDVALIDITY = "UIDVALIDITY";
    private static final String UNSEEN = "UNSEEN";
    private StatusCommandParser parser = new StatusCommandParser();

    StatusCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        String string = this.parser.mailbox(imapRequestLineReader);
        StatusDataItems statusDataItems = this.parser.statusDataItems(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        MailFolder mailFolder = this.getMailbox(string, imapSession, true);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" ");
        stringBuffer.append("(");
        if (statusDataItems.messages) {
            stringBuffer.append(MESSAGES);
            stringBuffer.append(" ");
            stringBuffer.append(mailFolder.getMessageCount());
            stringBuffer.append(" ");
        }
        if (statusDataItems.recent) {
            stringBuffer.append(RECENT);
            stringBuffer.append(" ");
            stringBuffer.append(mailFolder.getRecentCount(false));
            stringBuffer.append(" ");
        }
        if (statusDataItems.uidNext) {
            stringBuffer.append(UIDNEXT);
            stringBuffer.append(" ");
            stringBuffer.append(mailFolder.getUidNext());
            stringBuffer.append(" ");
        }
        if (statusDataItems.uidValidity) {
            stringBuffer.append(UIDVALIDITY);
            stringBuffer.append(" ");
            stringBuffer.append(mailFolder.getUidValidity());
            stringBuffer.append(" ");
        }
        if (statusDataItems.unseen) {
            stringBuffer.append(UNSEEN);
            stringBuffer.append(" ");
            stringBuffer.append(mailFolder.getUnseenCount());
            stringBuffer.append(" ");
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append(')');
        imapResponse.commandResponse(this, stringBuffer.toString());
        imapSession.unsolicitedResponses(imapResponse);
        imapResponse.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class StatusDataItems {
        boolean messages;
        boolean recent;
        boolean uidNext;
        boolean uidValidity;
        boolean unseen;

        private StatusDataItems() {
        }
    }

    private class StatusCommandParser
    extends CommandParser {
        private StatusCommandParser() {
        }

        StatusDataItems statusDataItems(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            StatusDataItems statusDataItems = new StatusDataItems();
            imapRequestLineReader.nextWordChar();
            this.consumeChar(imapRequestLineReader, '(');
            CommandParser.NoopCharValidator noopCharValidator = new CommandParser.NoopCharValidator();
            String string = this.consumeWord(imapRequestLineReader, noopCharValidator);
            while (!string.endsWith(")")) {
                this.addItem(string, statusDataItems);
                string = this.consumeWord(imapRequestLineReader, noopCharValidator);
            }
            if (string.length() > 1) {
                this.addItem(string.substring(0, string.length() - 1), statusDataItems);
            }
            return statusDataItems;
        }

        private void addItem(String string, StatusDataItems statusDataItems) throws ProtocolException {
            if (string.equals(StatusCommand.MESSAGES)) {
                statusDataItems.messages = true;
            } else if (string.equals(StatusCommand.RECENT)) {
                statusDataItems.recent = true;
            } else if (string.equals(StatusCommand.UIDNEXT)) {
                statusDataItems.uidNext = true;
            } else if (string.equals(StatusCommand.UIDVALIDITY)) {
                statusDataItems.uidValidity = true;
            } else if (string.equals(StatusCommand.UNSEEN)) {
                statusDataItems.unseen = true;
            } else {
                throw new ProtocolException("Unknown status item: '" + string + "'");
            }
        }
    }
}

