/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import javax.mail.Flags;

class StoreCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "STORE";
    public static final String ARGS = "<Message-set> ['+'|'-']FLAG[.SILENT] <flag-list>";
    private final StoreCommandParser parser = new StoreCommandParser();

    StoreCommand() {
    }

    protected void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession) throws ProtocolException, FolderException {
        this.doProcess(imapRequestLineReader, imapResponse, imapSession, false);
    }

    public void doProcess(ImapRequestLineReader imapRequestLineReader, ImapResponse imapResponse, ImapSession imapSession, boolean bl) throws ProtocolException, FolderException {
        int n;
        IdRange[] idRangeArray = this.parser.parseIdRange(imapRequestLineReader);
        StoreDirective storeDirective = this.parser.storeDirective(imapRequestLineReader);
        Flags flags = this.parser.flagList(imapRequestLineReader);
        this.parser.endLine(imapRequestLineReader);
        ImapSessionFolder imapSessionFolder = imapSession.getSelected();
        ImapSessionFolder imapSessionFolder2 = null;
        if (storeDirective.isSilent()) {
            imapSessionFolder2 = imapSessionFolder;
        }
        long[] lArray = imapSessionFolder.getMessageUids();
        for (n = 0; n < lArray.length; ++n) {
            long l = lArray[n];
            int n2 = imapSessionFolder.getMsn(l);
            if ((!bl || !this.includes(idRangeArray, l)) && (bl || !this.includes(idRangeArray, n2))) continue;
            if (storeDirective.getSign() < 0) {
                imapSessionFolder.setFlags(flags, false, l, imapSessionFolder2, bl);
                continue;
            }
            if (storeDirective.getSign() > 0) {
                imapSessionFolder.setFlags(flags, true, l, imapSessionFolder2, bl);
                continue;
            }
            imapSessionFolder.replaceFlags(flags, l, imapSessionFolder2, bl);
        }
        n = !bl ? 1 : 0;
        imapSession.unsolicitedResponses(imapResponse, n != 0);
        imapResponse.commandComplete(this);
    }

    private void storeFlags(SimpleStoredMessage simpleStoredMessage, StoreDirective storeDirective, Flags flags) {
        Flags flags2 = simpleStoredMessage.getFlags();
        if (storeDirective.getSign() == 0) {
            flags2.remove(MessageFlags.ALL_FLAGS);
            flags2.add(flags);
        } else if (storeDirective.getSign() < 0) {
            flags2.remove(flags);
        } else if (storeDirective.getSign() > 0) {
            flags2.add(flags);
        }
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class StoreDirective {
        private int sign;
        private boolean silent;

        public StoreDirective(int n, boolean bl) {
            this.sign = n;
            this.silent = bl;
        }

        public int getSign() {
            return this.sign;
        }

        public boolean isSilent() {
            return this.silent;
        }
    }

    private class StoreCommandParser
    extends CommandParser {
        private StoreCommandParser() {
        }

        StoreDirective storeDirective(ImapRequestLineReader imapRequestLineReader) throws ProtocolException {
            int n = 0;
            boolean bl = false;
            char c = imapRequestLineReader.nextWordChar();
            if (c == '+') {
                n = 1;
                imapRequestLineReader.consume();
            } else if (c == '-') {
                n = -1;
                imapRequestLineReader.consume();
            } else {
                n = 0;
            }
            String string = this.consumeWord(imapRequestLineReader, new CommandParser.NoopCharValidator());
            if ("FLAGS".equalsIgnoreCase(string)) {
                bl = false;
            } else if ("FLAGS.SILENT".equalsIgnoreCase(string)) {
                bl = true;
            } else {
                throw new ProtocolException("Invalid Store Directive: '" + string + "'");
            }
            return new StoreDirective(n, bl);
        }
    }
}

