/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.foedus.util.StreamUtils;
import com.icegreen.greenmail.pop3.Pop3Handler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class Pop3Connection {
    Pop3Handler _handler;
    private static final int TIMEOUT_MILLIS = 30000;
    Socket _socket;
    InetAddress _clientAddress;
    BufferedReader _in;
    InternetPrintWriter _out;

    public Pop3Connection(Pop3Handler pop3Handler, Socket socket) throws IOException {
        this.configureSocket(socket);
        this.configureStreams();
        this._handler = pop3Handler;
    }

    private void configureStreams() throws IOException {
        OutputStream outputStream = this._socket.getOutputStream();
        InputStream inputStream = this._socket.getInputStream();
        this._out = new InternetPrintWriter(outputStream, true);
        this._in = new BufferedReader(new InputStreamReader(inputStream));
    }

    private void configureSocket(Socket socket) throws SocketException {
        this._socket = socket;
        this._socket.setSoTimeout(30000);
        this._clientAddress = this._socket.getInetAddress();
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public void quit() {
        this._handler.quit();
    }

    public void println(String string) {
        System.out.println("S: " + string);
        this._out.print(string);
        this.println();
    }

    public void println() {
        this._out.print("\r\n");
        this._out.flush();
    }

    public void print(Reader reader) throws IOException {
        StreamUtils.copy(reader, this._out);
        this._out.flush();
    }

    public String readLine() throws IOException {
        String string = this._in.readLine();
        System.out.println("C: " + string);
        return string;
    }

    public String getClientAddress() {
        return this._clientAddress.toString();
    }
}

