/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.pop3.commands.Pop3CommandRegistry;
import com.icegreen.greenmail.user.UserManager;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.StringTokenizer;

public class Pop3Handler
extends Thread {
    Pop3CommandRegistry _registry;
    Pop3Connection _conn;
    UserManager _manager;
    Pop3State _state;
    boolean _quitting;
    String _currentLine;
    private Socket _socket;

    public Pop3Handler(Pop3CommandRegistry pop3CommandRegistry, UserManager userManager, Socket socket) {
        this._registry = pop3CommandRegistry;
        this._manager = userManager;
        this._socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._conn = new Pop3Connection(this, this._socket);
            this._state = new Pop3State(this._manager);
            this._quitting = false;
            this.sendGreetings();
            while (!this._quitting) {
                this.handleCommand();
            }
            this._conn.close();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this._conn.println("421 Service shutting down and closing transmission channel");
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    void sendGreetings() {
        this._conn.println("+OK POP3 GreenMail Server ready");
    }

    void handleCommand() throws IOException {
        this._currentLine = this._conn.readLine();
        if (this._currentLine == null) {
            this.quit();
            return;
        }
        String string = new StringTokenizer(this._currentLine, " ").nextToken().toUpperCase();
        Pop3Command pop3Command = this._registry.getCommand(string);
        if (pop3Command == null) {
            this._conn.println("-ERR Command not recognized");
            return;
        }
        if (!pop3Command.isValidForState(this._state)) {
            this._conn.println("-ERR Command not valid for this state");
            return;
        }
        pop3Command.execute(this._conn, this._state, this._currentLine);
    }

    public void quit() {
        this._quitting = true;
        try {
            if (this._socket != null && !this._socket.isClosed()) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

