/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.smtp.SmtpHandler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SmtpConnection {
    private static final int TIMEOUT_MILLIS = 30000;
    private InetAddress serverAddress;
    Socket sock;
    InetAddress clientAddress;
    InternetPrintWriter out;
    BufferedReader in;
    SmtpHandler handler;
    String heloName;

    public SmtpConnection(SmtpHandler smtpHandler, Socket socket) throws IOException {
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sock = socket;
        socket.setSoTimeout(30000);
        this.clientAddress = socket.getInetAddress();
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        this.out = new InternetPrintWriter(outputStream, true);
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.handler = smtpHandler;
    }

    SmtpConnection() {
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void println(String string) {
        this.out.println(string);
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public String readLine() throws IOException {
        String string = this.in.readLine();
        return string;
    }

    public String getClientAddress() {
        return this.clientAddress.getHostName();
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public String getServerGreetingsName() {
        InetAddress inetAddress = this.getServerAddress();
        if (inetAddress != null) {
            return inetAddress.toString();
        }
        return System.getProperty("user.name");
    }

    public String getHeloName() {
        return this.heloName;
    }

    public void setHeloName(String string) {
        this.heloName = string;
    }

    public void quit() {
        this.handler.quit();
    }
}

