/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;

public class MailCommand
extends SmtpCommand {
    static final Pattern param = Pattern.compile("MAIL FROM:\\s?<(.*)>", 2);

    public void execute(SmtpConnection smtpConnection, SmtpState smtpState, SmtpManager smtpManager, String string) {
        Matcher matcher = param.matcher(string);
        try {
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                MailAddress mailAddress = new MailAddress(string2);
                String string3 = smtpManager.checkSender(smtpState, mailAddress);
                if (string3 != null) {
                    smtpConnection.println(string3);
                    return;
                }
                smtpState.clearMessage();
                smtpState.getMessage().setReturnPath(mailAddress);
                smtpConnection.println("250 OK");
            } else {
                smtpConnection.println("501 Required syntax: 'MAIL FROM:<email@host>'");
            }
        }
        catch (AddressException addressException) {
            smtpConnection.println("501 Malformed email address. Use form email@host");
        }
    }
}

