/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.smtp.commands.DataCommand;
import com.icegreen.greenmail.smtp.commands.HeloCommand;
import com.icegreen.greenmail.smtp.commands.MailCommand;
import com.icegreen.greenmail.smtp.commands.NoopCommand;
import com.icegreen.greenmail.smtp.commands.QuitCommand;
import com.icegreen.greenmail.smtp.commands.RcptCommand;
import com.icegreen.greenmail.smtp.commands.RsetCommand;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import com.icegreen.greenmail.smtp.commands.VrfyCommand;
import java.util.HashMap;
import java.util.Map;

public class SmtpCommandRegistry {
    private static Map commands = new HashMap();
    private static Object[][] COMMANDS = new Object[][]{{"HELO", new HeloCommand()}, {"EHLO", new HeloCommand()}, {"NOOP", new NoopCommand()}, {"RSET", new RsetCommand()}, {"QUIT", new QuitCommand()}, {"MAIL", new MailCommand()}, {"RCPT", new RcptCommand()}, {"DATA", new DataCommand()}, {"VRFY", new VrfyCommand()}};

    public void load() throws Exception {
        for (int i = 0; i < COMMANDS.length; ++i) {
            String string = COMMANDS[i][0].toString();
            if (commands.containsKey(string)) continue;
            SmtpCommand smtpCommand = (SmtpCommand)COMMANDS[i][1];
            this.registerCommand(string, smtpCommand);
            continue;
        }
    }

    private void registerCommand(String string, SmtpCommand smtpCommand) {
        commands.put(string, smtpCommand);
    }

    public SmtpCommand getCommand(String string) {
        if (commands.size() == 0) {
            try {
                this.load();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return (SmtpCommand)commands.get(string);
    }
}

